/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.table.simple;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.table.XEasyPdfTableStyle;
import wiki.xsx.core.pdf.component.table.simple.XEasyPdfSimpleRow;
import wiki.xsx.core.pdf.component.table.simple.XEasyPdfSimpleTableParam;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.page.XEasyPdfPage;

public class XEasyPdfSimpleTable
implements XEasyPdfComponent {
    private final XEasyPdfSimpleTableParam param = new XEasyPdfSimpleTableParam();

    public XEasyPdfSimpleTable(XEasyPdfSimpleRow ... rows) {
        Collections.addAll(this.param.getRows(), rows);
    }

    public XEasyPdfSimpleTable(List<XEasyPdfSimpleRow> rowList) {
        this.param.getRows().addAll(rowList);
    }

    public XEasyPdfSimpleTable setFontPath(String fontPath) {
        this.param.setFontPath(fontPath);
        return this;
    }

    public XEasyPdfSimpleTable setFont(PDFont font) {
        this.param.setFont(font);
        this.param.setFontPath("");
        return this;
    }

    public XEasyPdfSimpleTable setFontSize(float fontSize) {
        this.param.setFontSize(fontSize);
        return this;
    }

    public XEasyPdfSimpleTable setMarginLeft(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfSimpleTable setMarginTop(float margin) {
        this.param.setMarginTop(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfSimpleTable setMarginBottom(float margin) {
        this.param.setMarginBottom(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfSimpleTable setStyle(XEasyPdfTableStyle style) {
        this.param.setStyle(style);
        return this;
    }

    public PDFont getFont() {
        return this.param.getFont();
    }

    public XEasyPdfSimpleTable enableBorder() {
        this.param.setHasBorder(true);
        return this;
    }

    public XEasyPdfSimpleTable disableBorder() {
        this.param.setHasBorder(false);
        return this;
    }

    @Override
    public XEasyPdfSimpleTable setPosition(float beginX, float beginY) {
        this.param.setBeginX(Float.valueOf(beginX)).setBeginY(Float.valueOf(beginY));
        return this;
    }

    @Override
    @Deprecated
    public XEasyPdfSimpleTable setWidth(float width) {
        return this;
    }

    @Override
    @Deprecated
    public XEasyPdfSimpleTable setHeight(float height) {
        return this;
    }

    @Override
    public XEasyPdfSimpleTable setContentMode(XEasyPdfComponent.ContentMode mode) {
        this.param.setContentMode(mode);
        return this;
    }

    public XEasyPdfSimpleTable addRow(XEasyPdfSimpleRow ... rows) {
        Collections.addAll(this.param.getRows(), rows);
        return this;
    }

    public XEasyPdfSimpleTable addRow(List<XEasyPdfSimpleRow> rowList) {
        this.param.getRows().addAll(rowList);
        return this;
    }

    XEasyPdfSimpleTableParam getParam() {
        return this.param;
    }

    @Override
    public void draw(XEasyPdfDocument document, XEasyPdfPage page) throws IOException {
        page.disablePosition();
        this.param.init(document, page, this);
        if (this.param.getBeginX() != null) {
            page.getParam().setPageX(this.param.getBeginX());
        }
        if (this.param.getBeginY() != null) {
            page.getParam().setPageY(Float.valueOf(this.param.getBeginY().floatValue() - this.param.getMarginTop().floatValue()));
        } else {
            page.getParam().setPageY(Float.valueOf(page.getParam().getPageY() == null ? page.getLastPage().getMediaBox().getHeight() - this.param.getMarginTop().floatValue() : page.getParam().getPageY().floatValue() - this.param.getMarginTop().floatValue()));
        }
        List<XEasyPdfSimpleRow> rows = this.param.getRows();
        for (XEasyPdfSimpleRow row : rows) {
            row.doDraw(document, page, this);
        }
        page.enablePosition();
        this.param.setDraw(true);
        if (this.param.getFontPath() != null && this.param.getFontPath().length() > 0) {
            this.param.getFont().subset();
            this.param.setFont(null);
        }
    }

    @Override
    public boolean isDraw() {
        return this.param.isDraw();
    }
}

