/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.text;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.text.XEasyPdfTextStyle;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.page.XEasyPdfPage;
import wiki.xsx.core.pdf.util.XEasyPdfFontUtil;
import wiki.xsx.core.pdf.util.XEasyPdfTextUtil;

class XEasyPdfTextParam {
    private XEasyPdfComponent.ContentMode contentMode = XEasyPdfComponent.ContentMode.APPEND;
    private String fontPath;
    private PDFont font;
    private Float fontSize = Float.valueOf(12.0f);
    private Float fontHeight;
    private Float leading = Float.valueOf(5.0f);
    private Float marginLeft = Float.valueOf(0.0f);
    private Float marginRight = Float.valueOf(0.0f);
    private Float marginTop = Float.valueOf(0.0f);
    private Float marginBottom = Float.valueOf(0.0f);
    private Float maxWidth;
    private Float maxHeight;
    private String text;
    private List<String> splitTextList;
    private XEasyPdfTextStyle style;
    private Float beginX;
    private Float beginY;
    private Color fontColor = Color.BLACK;
    private boolean useSelfStyle = false;
    private boolean isNewLine = true;
    private boolean checkPage = true;
    private boolean isTextAppend = false;
    private boolean isChildComponent = false;
    private boolean isDraw = false;

    void init(XEasyPdfDocument document, XEasyPdfPage page) throws IOException {
        PDRectangle rectangle = page.getLastPage().getMediaBox();
        if (this.maxWidth == null) {
            this.maxWidth = Float.valueOf(rectangle.getWidth());
        }
        if (this.maxHeight == null) {
            this.maxHeight = Float.valueOf(rectangle.getHeight());
        }
        if (this.font == null) {
            this.font = XEasyPdfFontUtil.loadFont(document, page, this.fontPath);
        }
        this.fontHeight = this.fontSize;
        if (this.beginX == null) {
            this.beginX = Float.valueOf(this.isTextAppend ? this.marginLeft.floatValue() + (page.getParam().getPageX() == null ? 0.0f : page.getParam().getPageX().floatValue()) : this.marginLeft.floatValue());
        }
        if (this.beginY == null) {
            this.beginY = Float.valueOf(this.isTextAppend ? (page.getParam().getPageY() == null ? this.maxHeight.floatValue() - this.marginTop.floatValue() - this.fontHeight.floatValue() - this.leading.floatValue() : page.getParam().getPageY().floatValue()) : (page.getParam().getPageY() == null ? this.maxHeight.floatValue() - this.marginTop.floatValue() - this.fontHeight.floatValue() - this.leading.floatValue() : page.getParam().getPageY().floatValue() - this.marginTop.floatValue() - this.fontHeight.floatValue() - this.leading.floatValue()));
        }
        if (this.splitTextList == null) {
            if (this.isTextAppend) {
                List<String> splitLines = XEasyPdfTextUtil.splitLines(this.text, this.maxWidth.floatValue() - this.beginX.floatValue() - this.marginRight.floatValue(), this.font, this.fontSize.floatValue());
                if (!splitLines.isEmpty()) {
                    this.splitTextList = new ArrayList<String>(splitLines.size());
                    String firstLineText = splitLines.get(0);
                    this.splitTextList.add(firstLineText);
                    this.splitTextList.addAll(XEasyPdfTextUtil.splitLines(this.text.substring(firstLineText.length()), this.maxWidth.floatValue() - this.marginLeft.floatValue() - this.marginRight.floatValue(), this.font, this.fontSize.floatValue()));
                } else {
                    this.splitTextList = splitLines;
                }
            } else {
                this.splitTextList = XEasyPdfTextUtil.splitLines(this.text, this.maxWidth.floatValue() - this.marginLeft.floatValue() - this.marginRight.floatValue(), this.font, this.fontSize.floatValue());
            }
        }
    }

    float getWidth(XEasyPdfDocument document, XEasyPdfPage page, float marginLeft, float marginRight) throws IOException {
        if (this.maxWidth != null) {
            return this.maxWidth.floatValue();
        }
        this.marginLeft = Float.valueOf(marginLeft);
        this.marginRight = Float.valueOf(marginRight);
        this.init(document, page);
        return this.maxWidth.floatValue();
    }

    float getHeight(XEasyPdfDocument document, XEasyPdfPage page, float marginLeft, float marginRight) throws IOException {
        if (this.maxHeight != null) {
            return this.maxHeight.floatValue();
        }
        this.marginLeft = Float.valueOf(marginLeft);
        this.marginRight = Float.valueOf(marginRight);
        this.init(document, page);
        return (this.fontHeight.floatValue() + this.leading.floatValue()) * (float)this.splitTextList.size() - this.leading.floatValue() + this.marginTop.floatValue() + this.marginBottom.floatValue();
    }

    public XEasyPdfComponent.ContentMode getContentMode() {
        return this.contentMode;
    }

    public String getFontPath() {
        return this.fontPath;
    }

    public PDFont getFont() {
        return this.font;
    }

    public Float getFontSize() {
        return this.fontSize;
    }

    public Float getFontHeight() {
        return this.fontHeight;
    }

    public Float getLeading() {
        return this.leading;
    }

    public Float getMarginLeft() {
        return this.marginLeft;
    }

    public Float getMarginRight() {
        return this.marginRight;
    }

    public Float getMarginTop() {
        return this.marginTop;
    }

    public Float getMarginBottom() {
        return this.marginBottom;
    }

    public Float getMaxWidth() {
        return this.maxWidth;
    }

    public Float getMaxHeight() {
        return this.maxHeight;
    }

    public String getText() {
        return this.text;
    }

    public List<String> getSplitTextList() {
        return this.splitTextList;
    }

    public XEasyPdfTextStyle getStyle() {
        return this.style;
    }

    public Float getBeginX() {
        return this.beginX;
    }

    public Float getBeginY() {
        return this.beginY;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public boolean isUseSelfStyle() {
        return this.useSelfStyle;
    }

    public boolean isNewLine() {
        return this.isNewLine;
    }

    public boolean isCheckPage() {
        return this.checkPage;
    }

    public boolean isTextAppend() {
        return this.isTextAppend;
    }

    public boolean isChildComponent() {
        return this.isChildComponent;
    }

    public boolean isDraw() {
        return this.isDraw;
    }

    public XEasyPdfTextParam setContentMode(XEasyPdfComponent.ContentMode contentMode) {
        this.contentMode = contentMode;
        return this;
    }

    public XEasyPdfTextParam setFontPath(String fontPath) {
        this.fontPath = fontPath;
        return this;
    }

    public XEasyPdfTextParam setFont(PDFont font) {
        this.font = font;
        return this;
    }

    public XEasyPdfTextParam setFontSize(Float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public XEasyPdfTextParam setFontHeight(Float fontHeight) {
        this.fontHeight = fontHeight;
        return this;
    }

    public XEasyPdfTextParam setLeading(Float leading) {
        this.leading = leading;
        return this;
    }

    public XEasyPdfTextParam setMarginLeft(Float marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    public XEasyPdfTextParam setMarginRight(Float marginRight) {
        this.marginRight = marginRight;
        return this;
    }

    public XEasyPdfTextParam setMarginTop(Float marginTop) {
        this.marginTop = marginTop;
        return this;
    }

    public XEasyPdfTextParam setMarginBottom(Float marginBottom) {
        this.marginBottom = marginBottom;
        return this;
    }

    public XEasyPdfTextParam setMaxWidth(Float maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public XEasyPdfTextParam setMaxHeight(Float maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public XEasyPdfTextParam setText(String text) {
        this.text = text;
        return this;
    }

    public XEasyPdfTextParam setSplitTextList(List<String> splitTextList) {
        this.splitTextList = splitTextList;
        return this;
    }

    public XEasyPdfTextParam setStyle(XEasyPdfTextStyle style) {
        this.style = style;
        return this;
    }

    public XEasyPdfTextParam setBeginX(Float beginX) {
        this.beginX = beginX;
        return this;
    }

    public XEasyPdfTextParam setBeginY(Float beginY) {
        this.beginY = beginY;
        return this;
    }

    public XEasyPdfTextParam setFontColor(Color fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public XEasyPdfTextParam setUseSelfStyle(boolean useSelfStyle) {
        this.useSelfStyle = useSelfStyle;
        return this;
    }

    public XEasyPdfTextParam setNewLine(boolean isNewLine) {
        this.isNewLine = isNewLine;
        return this;
    }

    public XEasyPdfTextParam setCheckPage(boolean checkPage) {
        this.checkPage = checkPage;
        return this;
    }

    public XEasyPdfTextParam setTextAppend(boolean isTextAppend) {
        this.isTextAppend = isTextAppend;
        return this;
    }

    public XEasyPdfTextParam setChildComponent(boolean isChildComponent) {
        this.isChildComponent = isChildComponent;
        return this;
    }

    public XEasyPdfTextParam setDraw(boolean isDraw) {
        this.isDraw = isDraw;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfTextParam)) {
            return false;
        }
        XEasyPdfTextParam other = (XEasyPdfTextParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseSelfStyle() != other.isUseSelfStyle()) {
            return false;
        }
        if (this.isNewLine() != other.isNewLine()) {
            return false;
        }
        if (this.isCheckPage() != other.isCheckPage()) {
            return false;
        }
        if (this.isTextAppend() != other.isTextAppend()) {
            return false;
        }
        if (this.isChildComponent() != other.isChildComponent()) {
            return false;
        }
        if (this.isDraw() != other.isDraw()) {
            return false;
        }
        Float this$fontSize = this.getFontSize();
        Float other$fontSize = other.getFontSize();
        if (this$fontSize == null ? other$fontSize != null : !((Object)this$fontSize).equals(other$fontSize)) {
            return false;
        }
        Float this$fontHeight = this.getFontHeight();
        Float other$fontHeight = other.getFontHeight();
        if (this$fontHeight == null ? other$fontHeight != null : !((Object)this$fontHeight).equals(other$fontHeight)) {
            return false;
        }
        Float this$leading = this.getLeading();
        Float other$leading = other.getLeading();
        if (this$leading == null ? other$leading != null : !((Object)this$leading).equals(other$leading)) {
            return false;
        }
        Float this$marginLeft = this.getMarginLeft();
        Float other$marginLeft = other.getMarginLeft();
        if (this$marginLeft == null ? other$marginLeft != null : !((Object)this$marginLeft).equals(other$marginLeft)) {
            return false;
        }
        Float this$marginRight = this.getMarginRight();
        Float other$marginRight = other.getMarginRight();
        if (this$marginRight == null ? other$marginRight != null : !((Object)this$marginRight).equals(other$marginRight)) {
            return false;
        }
        Float this$marginTop = this.getMarginTop();
        Float other$marginTop = other.getMarginTop();
        if (this$marginTop == null ? other$marginTop != null : !((Object)this$marginTop).equals(other$marginTop)) {
            return false;
        }
        Float this$marginBottom = this.getMarginBottom();
        Float other$marginBottom = other.getMarginBottom();
        if (this$marginBottom == null ? other$marginBottom != null : !((Object)this$marginBottom).equals(other$marginBottom)) {
            return false;
        }
        Float this$maxWidth = this.getMaxWidth();
        Float other$maxWidth = other.getMaxWidth();
        if (this$maxWidth == null ? other$maxWidth != null : !((Object)this$maxWidth).equals(other$maxWidth)) {
            return false;
        }
        Float this$maxHeight = this.getMaxHeight();
        Float other$maxHeight = other.getMaxHeight();
        if (this$maxHeight == null ? other$maxHeight != null : !((Object)this$maxHeight).equals(other$maxHeight)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        XEasyPdfComponent.ContentMode this$contentMode = this.getContentMode();
        XEasyPdfComponent.ContentMode other$contentMode = other.getContentMode();
        if (this$contentMode == null ? other$contentMode != null : !((Object)((Object)this$contentMode)).equals((Object)other$contentMode)) {
            return false;
        }
        String this$fontPath = this.getFontPath();
        String other$fontPath = other.getFontPath();
        if (this$fontPath == null ? other$fontPath != null : !this$fontPath.equals(other$fontPath)) {
            return false;
        }
        PDFont this$font = this.getFont();
        PDFont other$font = other.getFont();
        if (this$font == null ? other$font != null : !this$font.equals(other$font)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        List<String> this$splitTextList = this.getSplitTextList();
        List<String> other$splitTextList = other.getSplitTextList();
        if (this$splitTextList == null ? other$splitTextList != null : !((Object)this$splitTextList).equals(other$splitTextList)) {
            return false;
        }
        XEasyPdfTextStyle this$style = this.getStyle();
        XEasyPdfTextStyle other$style = other.getStyle();
        if (this$style == null ? other$style != null : !((Object)((Object)this$style)).equals((Object)other$style)) {
            return false;
        }
        Color this$fontColor = this.getFontColor();
        Color other$fontColor = other.getFontColor();
        return !(this$fontColor == null ? other$fontColor != null : !((Object)this$fontColor).equals(other$fontColor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfTextParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseSelfStyle() ? 79 : 97);
        result = result * 59 + (this.isNewLine() ? 79 : 97);
        result = result * 59 + (this.isCheckPage() ? 79 : 97);
        result = result * 59 + (this.isTextAppend() ? 79 : 97);
        result = result * 59 + (this.isChildComponent() ? 79 : 97);
        result = result * 59 + (this.isDraw() ? 79 : 97);
        Float $fontSize = this.getFontSize();
        result = result * 59 + ($fontSize == null ? 43 : ((Object)$fontSize).hashCode());
        Float $fontHeight = this.getFontHeight();
        result = result * 59 + ($fontHeight == null ? 43 : ((Object)$fontHeight).hashCode());
        Float $leading = this.getLeading();
        result = result * 59 + ($leading == null ? 43 : ((Object)$leading).hashCode());
        Float $marginLeft = this.getMarginLeft();
        result = result * 59 + ($marginLeft == null ? 43 : ((Object)$marginLeft).hashCode());
        Float $marginRight = this.getMarginRight();
        result = result * 59 + ($marginRight == null ? 43 : ((Object)$marginRight).hashCode());
        Float $marginTop = this.getMarginTop();
        result = result * 59 + ($marginTop == null ? 43 : ((Object)$marginTop).hashCode());
        Float $marginBottom = this.getMarginBottom();
        result = result * 59 + ($marginBottom == null ? 43 : ((Object)$marginBottom).hashCode());
        Float $maxWidth = this.getMaxWidth();
        result = result * 59 + ($maxWidth == null ? 43 : ((Object)$maxWidth).hashCode());
        Float $maxHeight = this.getMaxHeight();
        result = result * 59 + ($maxHeight == null ? 43 : ((Object)$maxHeight).hashCode());
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        XEasyPdfComponent.ContentMode $contentMode = this.getContentMode();
        result = result * 59 + ($contentMode == null ? 43 : ((Object)((Object)$contentMode)).hashCode());
        String $fontPath = this.getFontPath();
        result = result * 59 + ($fontPath == null ? 43 : $fontPath.hashCode());
        PDFont $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : $font.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        List<String> $splitTextList = this.getSplitTextList();
        result = result * 59 + ($splitTextList == null ? 43 : ((Object)$splitTextList).hashCode());
        XEasyPdfTextStyle $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : ((Object)((Object)$style)).hashCode());
        Color $fontColor = this.getFontColor();
        result = result * 59 + ($fontColor == null ? 43 : ((Object)$fontColor).hashCode());
        return result;
    }

    public String toString() {
        return "XEasyPdfTextParam(contentMode=" + (Object)((Object)this.getContentMode()) + ", fontPath=" + this.getFontPath() + ", font=" + this.getFont() + ", fontSize=" + this.getFontSize() + ", fontHeight=" + this.getFontHeight() + ", leading=" + this.getLeading() + ", marginLeft=" + this.getMarginLeft() + ", marginRight=" + this.getMarginRight() + ", marginTop=" + this.getMarginTop() + ", marginBottom=" + this.getMarginBottom() + ", maxWidth=" + this.getMaxWidth() + ", maxHeight=" + this.getMaxHeight() + ", text=" + this.getText() + ", splitTextList=" + this.getSplitTextList() + ", style=" + (Object)((Object)this.getStyle()) + ", beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", fontColor=" + this.getFontColor() + ", useSelfStyle=" + this.isUseSelfStyle() + ", isNewLine=" + this.isNewLine() + ", checkPage=" + this.isCheckPage() + ", isTextAppend=" + this.isTextAppend() + ", isChildComponent=" + this.isChildComponent() + ", isDraw=" + this.isDraw() + ")";
    }
}

