/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.doc;

import java.awt.Color;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.print.PrintServiceLookup;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdfwriter.COSWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.printing.PDFPrintable;
import org.apache.pdfbox.printing.Scaling;
import wiki.xsx.core.pdf.component.image.XEasyPdfImage;
import wiki.xsx.core.pdf.doc.XEasyPdfDocumentExtractor;
import wiki.xsx.core.pdf.doc.XEasyPdfDocumentImager;
import wiki.xsx.core.pdf.doc.XEasyPdfDocumentInfo;
import wiki.xsx.core.pdf.doc.XEasyPdfDocumentParam;
import wiki.xsx.core.pdf.doc.XEasyPdfDocumentPermission;
import wiki.xsx.core.pdf.doc.XEasyPdfDocumentSplitter;
import wiki.xsx.core.pdf.doc.XEasyPdfPrintStyle;
import wiki.xsx.core.pdf.footer.XEasyPdfFooter;
import wiki.xsx.core.pdf.header.XEasyPdfHeader;
import wiki.xsx.core.pdf.mark.XEasyPdfWatermark;
import wiki.xsx.core.pdf.page.XEasyPdfPage;
import wiki.xsx.core.pdf.page.XEasyPdfPageParam;
import wiki.xsx.core.pdf.util.XEasyPdfFontUtil;

public class XEasyPdfDocument {
    private final XEasyPdfDocumentParam param = new XEasyPdfDocumentParam();

    public XEasyPdfDocument() {
        this.param.setSource(new PDDocument());
    }

    public XEasyPdfDocument(String filePath) throws IOException {
        try (InputStream inputStream = Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]);){
            this.param.setSource(PDDocument.load((InputStream)inputStream));
            PDPageTree pages = this.param.getSource().getPages();
            for (PDPage page : pages) {
                this.param.getPageList().add(new XEasyPdfPage(page));
            }
            this.param.initInfo(this);
        }
    }

    public XEasyPdfDocument(InputStream inputStream) throws IOException {
        this.param.setSource(PDDocument.load((InputStream)inputStream));
        PDPageTree pages = this.param.getSource().getPages();
        for (PDPage page : pages) {
            this.param.getPageList().add(new XEasyPdfPage(page));
        }
        this.param.initInfo(this);
    }

    public XEasyPdfDocumentInfo information() {
        this.param.setReset(true);
        return this.param.getDocumentInfo() != null ? this.param.getDocumentInfo() : new XEasyPdfDocumentInfo(this);
    }

    public XEasyPdfDocumentPermission permission() {
        this.param.setReset(true);
        return this.param.getPermission() != null ? this.param.getPermission() : new XEasyPdfDocumentPermission(this);
    }

    public XEasyPdfDocument setGlobalBackgroundColor(Color backgroundColor) {
        this.param.setReset(true);
        this.param.setBackgroundColor(backgroundColor);
        return this;
    }

    public Color getGlobalBackgroundColor() {
        return this.param.getBackgroundColor();
    }

    public XEasyPdfDocument setGlobalBackgroundImage(XEasyPdfImage globalBackgroundImage) {
        this.param.setReset(true);
        this.param.setGlobalBackgroundImage(globalBackgroundImage);
        return this;
    }

    public XEasyPdfImage getGlobalBackgroundImage() {
        return this.param.getGlobalBackgroundImage();
    }

    public XEasyPdfDocument setGlobalWatermark(XEasyPdfWatermark globalWatermark) {
        this.param.setReset(true);
        this.param.setGlobalWatermark(globalWatermark);
        return this;
    }

    public XEasyPdfWatermark getGlobalWatermark() {
        return this.param.getGlobalWatermark();
    }

    public XEasyPdfDocument setGlobalHeader(XEasyPdfHeader globalHeader) {
        this.param.setReset(true);
        this.param.setGlobalHeader(globalHeader);
        return this;
    }

    public XEasyPdfHeader getGlobalHeader() {
        return this.param.getGlobalHeader();
    }

    public XEasyPdfDocument setGlobalFooter(XEasyPdfFooter globalFooter) {
        this.param.setReset(true);
        this.param.setGlobalFooter(globalFooter);
        return this;
    }

    public XEasyPdfFooter getGlobalFooter() {
        return this.param.getGlobalFooter();
    }

    public XEasyPdfDocument setFontPath(String fontPath) {
        this.param.setReset(true);
        this.param.setFontPath(fontPath);
        return this;
    }

    public XEasyPdfDocument setFont(PDFont font) {
        this.param.setReset(true);
        this.param.setFont(font);
        return this;
    }

    public PDFont getFont() {
        return this.param.getFont();
    }

    public int getTotalPage() {
        int total = 0;
        List<XEasyPdfPage> pageList = this.getPageList();
        for (XEasyPdfPage xEasyPdfPage : pageList) {
            XEasyPdfPageParam pageParam = xEasyPdfPage.getParam();
            total += pageParam.getPageList().size() + pageParam.getNewPageList().size();
        }
        return total;
    }

    public XEasyPdfDocument addPage(XEasyPdfPage ... pages) {
        this.param.setReset(true);
        Collections.addAll(this.param.getPageList(), pages);
        return this;
    }

    public XEasyPdfDocument insertPage(int pageIndex, XEasyPdfPage ... pages) {
        this.param.setReset(true);
        List<XEasyPdfPage> pageList = this.param.getPageList();
        if (pageList.size() >= pageIndex) {
            for (XEasyPdfPage page : pages) {
                pageList.add(Math.max(pageIndex, 0), page);
            }
        } else {
            this.addPage(pages);
        }
        return this;
    }

    public XEasyPdfDocument modifyPageSize(PDRectangle pageSize, int ... pageIndex) {
        this.param.setReset(true);
        List<XEasyPdfPage> pageList = this.param.getPageList();
        if (pageIndex != null && pageIndex.length > 0) {
            for (int index : pageIndex) {
                pageList.get(index).modifyPageSize(pageSize);
            }
        } else {
            for (XEasyPdfPage xEasyPdfPage : pageList) {
                xEasyPdfPage.modifyPageSize(pageSize);
            }
        }
        return this;
    }

    public XEasyPdfDocument removePage(int ... pageIndex) {
        this.param.setReset(true);
        List<XEasyPdfPage> pageList = this.param.getPageList();
        for (int index : pageIndex) {
            pageList.remove(index);
        }
        return this;
    }

    public XEasyPdfDocument fillForm(Map<String, String> formMap) {
        this.param.setReset(true);
        this.param.setFormMap(formMap);
        return this;
    }

    public XEasyPdfDocument merge(XEasyPdfDocument ... documents) {
        this.param.setReset(true);
        for (XEasyPdfDocument document : documents) {
            this.param.getMergeSourceList().add(document);
            this.param.getPageList().addAll(document.getPageList());
        }
        return this;
    }

    public XEasyPdfDocumentImager imager() {
        return new XEasyPdfDocumentImager(this);
    }

    public XEasyPdfDocumentSplitter splitter() {
        return new XEasyPdfDocumentSplitter(this);
    }

    public XEasyPdfDocumentExtractor extractor() {
        return new XEasyPdfDocumentExtractor(this);
    }

    public XEasyPdfDocument save(String outputPath) throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(Paths.get(outputPath, new String[0]), new OpenOption[0]);){
            XEasyPdfDocument xEasyPdfDocument = this.save(outputStream);
            return xEasyPdfDocument;
        }
    }

    public XEasyPdfDocument save(OutputStream outputStream) throws IOException {
        COSWriter writer = new COSWriter(outputStream);
        PDDocument target = this.getTarget();
        this.setInfoAndPolicy(target);
        writer.write(target);
        return this;
    }

    public XEasyPdfDocument print(int count) throws IOException, PrinterException {
        return this.print(count, XEasyPdfPrintStyle.PORTRAIT, Scaling.ACTUAL_SIZE);
    }

    public XEasyPdfDocument print(int count, XEasyPdfPrintStyle style, Scaling scaling) throws IOException, PrinterException {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintService(PrintServiceLookup.lookupDefaultPrintService());
        Book book = new Book();
        PageFormat pageFormat = new PageFormat();
        pageFormat.setOrientation(style.getOrientation());
        book.append((Printable)new PDFPrintable(this.getTarget(), scaling), pageFormat);
        job.setPageable(book);
        job.setCopies(count);
        job.print();
        return this;
    }

    public void close() throws IOException {
        if (!this.param.getMergeSourceList().isEmpty()) {
            List<XEasyPdfDocument> mergeSourceList = this.param.getMergeSourceList();
            for (XEasyPdfDocument mergeSource : mergeSourceList) {
                mergeSource.close();
            }
        }
        if (this.param.getTarget() != null) {
            this.param.getTarget().close();
        }
        if (this.param.getSource() != null) {
            this.param.getSource().close();
        }
    }

    public PDDocument getTarget() throws IOException {
        if (this.param.getTarget() == null || this.param.isReset()) {
            this.initTarget();
        }
        return this.param.getTarget();
    }

    public PDDocument getSource() {
        return this.param.getSource();
    }

    public List<XEasyPdfPage> getPageList() {
        return this.param.getPageList();
    }

    void setInfo(XEasyPdfDocumentInfo info) {
        this.param.setDocumentInfo(info);
    }

    void setPermission(XEasyPdfDocumentPermission permission) {
        this.param.setPermission(permission);
    }

    void setInfoAndPolicy(PDDocument target) throws IOException {
        if (this.param.getDocumentInfo() != null) {
            target.setDocumentInformation(this.param.getDocumentInfo().getInfo());
        }
        if (this.param.getPermission() != null) {
            target.protect(this.param.getPermission().getPolicy());
        }
    }

    private void initTarget() throws IOException {
        PDDocument target = new PDDocument();
        if (this.getSource() != null) {
            target.getDocumentCatalog().setAcroForm(this.getSource().getDocumentCatalog().getAcroForm());
        }
        this.param.setTarget(target);
        this.param.setReset(false);
        this.param.initFont(this);
        List<XEasyPdfPage> pageList = this.param.getPageList();
        for (XEasyPdfPage pdfPage : pageList) {
            pdfPage.build(this);
            List<PDPage> pdfboxPageList = pdfPage.getParam().getPageList();
            for (PDPage page : pdfboxPageList) {
                PDPage importPage = target.importPage(page);
                importPage.setResources(page.getResources());
            }
            pdfboxPageList = pdfPage.getParam().getNewPageList();
            for (PDPage page : pdfboxPageList) {
                target.addPage(page);
            }
        }
        this.fillForm();
        if (this.param.getFontPath() != null && this.param.getFontPath().length() > 0) {
            this.param.getFont().subset();
            this.param.setFont(null);
        }
    }

    private void fillForm() throws IOException {
        Map<String, String> formMap = this.param.getFormMap();
        if (formMap != null && formMap.size() > 0) {
            if (this.param.getFontPath() == null) {
                throw new RuntimeException("the document font must be set");
            }
            PDAcroForm acroForm = this.getTarget().getDocumentCatalog().getAcroForm();
            if (acroForm != null) {
                PDResources resources = new PDResources();
                String defaultCosName = "AdobeSongStd-Light";
                resources.put(COSName.getPDFName((String)"AdobeSongStd-Light"), this.getFont());
                acroForm.setDefaultResources(resources);
                Set<Map.Entry<String, String>> entrySet = formMap.entrySet();
                for (Map.Entry<String, String> entry : entrySet) {
                    PDField field = acroForm.getField(entry.getKey());
                    if (field == null) continue;
                    XEasyPdfFontUtil.addToSubset(this.getFont(), entry.getValue());
                    field.setValue(entry.getValue());
                }
            }
        }
    }
}

