/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.doc;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import wiki.xsx.core.pdf.component.image.XEasyPdfImageType;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;

public class XEasyPdfDocumentImager {
    private final PDDocument document;
    private final XEasyPdfDocument pdfDocument;

    XEasyPdfDocumentImager(XEasyPdfDocument pdfDocument) {
        this.pdfDocument = pdfDocument;
        this.document = this.pdfDocument.getTarget();
    }

    public XEasyPdfDocumentImager image(String outputPath, XEasyPdfImageType imageType) throws IOException {
        return this.image(outputPath, imageType, null);
    }

    public XEasyPdfDocumentImager image(String outputPath, XEasyPdfImageType imageType, String prefix) throws IOException {
        if (prefix == null) {
            prefix = "x-easypdf";
        }
        String imageTypeName = imageType.name().toLowerCase();
        int pageCount = this.document.getNumberOfPages();
        for (int i = 0; i < pageCount; ++i) {
            StringBuilder fileNameBuilder = new StringBuilder();
            fileNameBuilder.append(outputPath).append(File.separator).append(prefix).append(i + 1).append('.').append(imageTypeName);
            try (OutputStream outputStream = Files.newOutputStream(Paths.get(fileNameBuilder.toString(), new String[0]), new OpenOption[0]);){
                PDFRenderer renderer = new PDFRenderer(this.document);
                BufferedImage bufferedImage = renderer.renderImage(i);
                ImageIO.write((RenderedImage)bufferedImage, imageTypeName, outputStream);
                continue;
            }
        }
        return this;
    }

    public XEasyPdfDocumentImager image(OutputStream outputStream, XEasyPdfImageType imageType, int pageIndex) throws IOException {
        pageIndex = Math.min(Math.max(pageIndex, 0), this.document.getNumberOfPages() - 1);
        PDFRenderer renderer = new PDFRenderer(this.document);
        BufferedImage bufferedImage = renderer.renderImage(pageIndex);
        ImageIO.write((RenderedImage)bufferedImage, imageType.name().toLowerCase(), outputStream);
        return this;
    }

    public XEasyPdfDocument finish() {
        return this.pdfDocument;
    }
}

