/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.footer;

import java.io.IOException;
import wiki.xsx.core.pdf.component.image.XEasyPdfImage;
import wiki.xsx.core.pdf.component.text.XEasyPdfText;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.page.XEasyPdfPage;

class XEasyPdfFooterParam {
    private XEasyPdfText text;
    private XEasyPdfImage image;
    private Float marginLeft = Float.valueOf(0.0f);
    private Float marginRight = Float.valueOf(0.0f);
    private Float marginBottom = Float.valueOf(5.0f);
    private Float beginX;
    private Float beginY;
    private Float height;

    void init(XEasyPdfDocument document, XEasyPdfPage page) throws IOException {
        if (this.text == null && this.image == null) {
            throw new IllegalArgumentException("text or image can not be found");
        }
        this.beginX = this.marginLeft;
        this.beginY = Float.valueOf(this.text == null ? 0.0f : this.text.getHeight(document, page, this.marginLeft.floatValue(), this.marginRight.floatValue()));
        if (this.height == null) {
            this.height = Float.valueOf(Math.max(this.beginY.floatValue(), this.image == null ? 0.0f : this.image.getHeight(document, page)) + this.marginBottom.floatValue());
        }
    }

    public XEasyPdfText getText() {
        return this.text;
    }

    public XEasyPdfImage getImage() {
        return this.image;
    }

    public Float getMarginLeft() {
        return this.marginLeft;
    }

    public Float getMarginRight() {
        return this.marginRight;
    }

    public Float getMarginBottom() {
        return this.marginBottom;
    }

    public Float getBeginX() {
        return this.beginX;
    }

    public Float getBeginY() {
        return this.beginY;
    }

    public Float getHeight() {
        return this.height;
    }

    public XEasyPdfFooterParam setText(XEasyPdfText text) {
        this.text = text;
        return this;
    }

    public XEasyPdfFooterParam setImage(XEasyPdfImage image) {
        this.image = image;
        return this;
    }

    public XEasyPdfFooterParam setMarginLeft(Float marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    public XEasyPdfFooterParam setMarginRight(Float marginRight) {
        this.marginRight = marginRight;
        return this;
    }

    public XEasyPdfFooterParam setMarginBottom(Float marginBottom) {
        this.marginBottom = marginBottom;
        return this;
    }

    public XEasyPdfFooterParam setBeginX(Float beginX) {
        this.beginX = beginX;
        return this;
    }

    public XEasyPdfFooterParam setBeginY(Float beginY) {
        this.beginY = beginY;
        return this;
    }

    public XEasyPdfFooterParam setHeight(Float height) {
        this.height = height;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfFooterParam)) {
            return false;
        }
        XEasyPdfFooterParam other = (XEasyPdfFooterParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$marginLeft = this.getMarginLeft();
        Float other$marginLeft = other.getMarginLeft();
        if (this$marginLeft == null ? other$marginLeft != null : !((Object)this$marginLeft).equals(other$marginLeft)) {
            return false;
        }
        Float this$marginRight = this.getMarginRight();
        Float other$marginRight = other.getMarginRight();
        if (this$marginRight == null ? other$marginRight != null : !((Object)this$marginRight).equals(other$marginRight)) {
            return false;
        }
        Float this$marginBottom = this.getMarginBottom();
        Float other$marginBottom = other.getMarginBottom();
        if (this$marginBottom == null ? other$marginBottom != null : !((Object)this$marginBottom).equals(other$marginBottom)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        Float this$height = this.getHeight();
        Float other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        XEasyPdfText this$text = this.getText();
        XEasyPdfText other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        XEasyPdfImage this$image = this.getImage();
        XEasyPdfImage other$image = other.getImage();
        return !(this$image == null ? other$image != null : !this$image.equals(other$image));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfFooterParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $marginLeft = this.getMarginLeft();
        result = result * 59 + ($marginLeft == null ? 43 : ((Object)$marginLeft).hashCode());
        Float $marginRight = this.getMarginRight();
        result = result * 59 + ($marginRight == null ? 43 : ((Object)$marginRight).hashCode());
        Float $marginBottom = this.getMarginBottom();
        result = result * 59 + ($marginBottom == null ? 43 : ((Object)$marginBottom).hashCode());
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        Float $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        XEasyPdfText $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        XEasyPdfImage $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        return result;
    }

    public String toString() {
        return "XEasyPdfFooterParam(text=" + this.getText() + ", image=" + this.getImage() + ", marginLeft=" + this.getMarginLeft() + ", marginRight=" + this.getMarginRight() + ", marginBottom=" + this.getMarginBottom() + ", beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", height=" + this.getHeight() + ")";
    }
}

