/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.header;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.image.XEasyPdfImage;
import wiki.xsx.core.pdf.component.line.XEasyPdfLine;
import wiki.xsx.core.pdf.component.text.XEasyPdfText;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.header.XEasyPdfHeader;
import wiki.xsx.core.pdf.header.XEasyPdfHeaderParam;
import wiki.xsx.core.pdf.page.XEasyPdfPage;

public class XEasyPdfDefaultHeader
implements XEasyPdfHeader {
    private final XEasyPdfHeaderParam param = new XEasyPdfHeaderParam();

    public XEasyPdfDefaultHeader(XEasyPdfImage image) {
        this.param.setImage(image);
    }

    public XEasyPdfDefaultHeader(XEasyPdfText text) {
        this.param.setText(text);
    }

    public XEasyPdfDefaultHeader(XEasyPdfImage image, XEasyPdfText text) {
        this.param.setImage(image).setText(text);
    }

    @Override
    public XEasyPdfDefaultHeader addSplitLine(XEasyPdfLine ... splitLine) {
        this.param.getLineList().addAll(Arrays.asList(splitLine));
        return this;
    }

    @Override
    public XEasyPdfDefaultHeader setMargin(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin)).setMarginRight(Float.valueOf(margin)).setMarginTop(Float.valueOf(margin));
        return this;
    }

    @Override
    public XEasyPdfDefaultHeader setMarginLeft(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin));
        return this;
    }

    @Override
    public XEasyPdfDefaultHeader setMarginRight(float margin) {
        this.param.setMarginRight(Float.valueOf(margin));
        return this;
    }

    @Override
    public XEasyPdfDefaultHeader setMarginTop(float margin) {
        this.param.setMarginTop(Float.valueOf(margin));
        return this;
    }

    @Override
    public float getHeight() {
        return this.param.getHeight() == null ? 0.0f : this.param.getHeight().floatValue();
    }

    @Override
    public void draw(XEasyPdfDocument document, XEasyPdfPage page) throws IOException {
        this.param.init(document, page);
        if (this.param.isTextPosition()) {
            if (this.param.getImage() != null) {
                page.disablePosition();
                this.param.getImage().setMarginTop(this.param.getMarginTop().floatValue()).setPosition(this.param.getBeginX().floatValue(), this.param.getBeginY().floatValue()).setContentMode(XEasyPdfComponent.ContentMode.PREPEND).draw(document, page);
                page.enablePosition();
            }
            this.param.getText().setMarginTop(this.param.getMarginTop().floatValue()).setMarginLeft(this.param.getMarginLeft().floatValue()).setMarginRight(this.param.getMarginRight().floatValue()).setCheckPage(false).draw(document, page);
        } else {
            if (this.param.getText() != null) {
                page.disablePosition();
                this.param.getText().setMarginTop(this.param.getMarginTop().floatValue()).setMarginLeft(this.param.getMarginLeft().floatValue()).setMarginRight(this.param.getMarginRight().floatValue()).setCheckPage(false).draw(document, page);
                page.enablePosition();
            }
            this.param.getImage().setMarginTop(this.param.getMarginTop().floatValue()).setPosition(this.param.getBeginX().floatValue(), this.param.getBeginY().floatValue()).setContentMode(XEasyPdfComponent.ContentMode.PREPEND).draw(document, page);
        }
        if (!this.param.getLineList().isEmpty()) {
            List<XEasyPdfLine> lineList = this.param.getLineList();
            for (XEasyPdfLine xEasyPdfLine : lineList) {
                xEasyPdfLine.setMarginLeft(this.param.getMarginLeft().floatValue()).setMarginRight(this.param.getMarginRight().floatValue()).draw(document, page);
            }
        }
    }
}

