/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.page;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.image.XEasyPdfImage;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.footer.XEasyPdfFooter;
import wiki.xsx.core.pdf.header.XEasyPdfHeader;
import wiki.xsx.core.pdf.mark.XEasyPdfWatermark;
import wiki.xsx.core.pdf.page.XEasyPdfPage;
import wiki.xsx.core.pdf.util.XEasyPdfFontUtil;

public class XEasyPdfPageParam {
    private String fontPath;
    private PDFont font;
    private Float pageX;
    private Float pageY;
    private PDRectangle pageSize = PDRectangle.A4;
    private PDRectangle modifyPageSize;
    private List<PDPage> pageList = new ArrayList<PDPage>(256);
    private List<PDPage> newPageList = new ArrayList<PDPage>(256);
    private List<XEasyPdfComponent> componentList = new ArrayList<XEasyPdfComponent>(128);
    private XEasyPdfWatermark watermark;
    private XEasyPdfImage backgroundImage;
    private XEasyPdfHeader header;
    private XEasyPdfFooter footer;
    private boolean allowWatermark = true;
    private boolean allowBackgroundImage = true;
    private boolean allowHeader = true;
    private boolean allowFooter = true;
    private boolean allowResetPosition = true;
    private Color backgroundColor;

    void init(XEasyPdfDocument document, XEasyPdfPage page) {
        if (this.fontPath != null) {
            this.font = XEasyPdfFontUtil.loadFont(document, page, this.fontPath);
        }
        if (this.backgroundColor == null) {
            this.backgroundColor = document.getGlobalBackgroundColor();
        }
    }

    public String getFontPath() {
        return this.fontPath;
    }

    public PDFont getFont() {
        return this.font;
    }

    public Float getPageX() {
        return this.pageX;
    }

    public Float getPageY() {
        return this.pageY;
    }

    public PDRectangle getPageSize() {
        return this.pageSize;
    }

    public PDRectangle getModifyPageSize() {
        return this.modifyPageSize;
    }

    public List<PDPage> getPageList() {
        return this.pageList;
    }

    public List<PDPage> getNewPageList() {
        return this.newPageList;
    }

    public List<XEasyPdfComponent> getComponentList() {
        return this.componentList;
    }

    public XEasyPdfWatermark getWatermark() {
        return this.watermark;
    }

    public XEasyPdfImage getBackgroundImage() {
        return this.backgroundImage;
    }

    public XEasyPdfHeader getHeader() {
        return this.header;
    }

    public XEasyPdfFooter getFooter() {
        return this.footer;
    }

    public boolean isAllowWatermark() {
        return this.allowWatermark;
    }

    public boolean isAllowBackgroundImage() {
        return this.allowBackgroundImage;
    }

    public boolean isAllowHeader() {
        return this.allowHeader;
    }

    public boolean isAllowFooter() {
        return this.allowFooter;
    }

    public boolean isAllowResetPosition() {
        return this.allowResetPosition;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public XEasyPdfPageParam setFontPath(String fontPath) {
        this.fontPath = fontPath;
        return this;
    }

    public XEasyPdfPageParam setFont(PDFont font) {
        this.font = font;
        return this;
    }

    public XEasyPdfPageParam setPageX(Float pageX) {
        this.pageX = pageX;
        return this;
    }

    public XEasyPdfPageParam setPageY(Float pageY) {
        this.pageY = pageY;
        return this;
    }

    public XEasyPdfPageParam setPageSize(PDRectangle pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public XEasyPdfPageParam setModifyPageSize(PDRectangle modifyPageSize) {
        this.modifyPageSize = modifyPageSize;
        return this;
    }

    public XEasyPdfPageParam setPageList(List<PDPage> pageList) {
        this.pageList = pageList;
        return this;
    }

    public XEasyPdfPageParam setNewPageList(List<PDPage> newPageList) {
        this.newPageList = newPageList;
        return this;
    }

    public XEasyPdfPageParam setComponentList(List<XEasyPdfComponent> componentList) {
        this.componentList = componentList;
        return this;
    }

    public XEasyPdfPageParam setWatermark(XEasyPdfWatermark watermark) {
        this.watermark = watermark;
        return this;
    }

    public XEasyPdfPageParam setBackgroundImage(XEasyPdfImage backgroundImage) {
        this.backgroundImage = backgroundImage;
        return this;
    }

    public XEasyPdfPageParam setHeader(XEasyPdfHeader header) {
        this.header = header;
        return this;
    }

    public XEasyPdfPageParam setFooter(XEasyPdfFooter footer) {
        this.footer = footer;
        return this;
    }

    public XEasyPdfPageParam setAllowWatermark(boolean allowWatermark) {
        this.allowWatermark = allowWatermark;
        return this;
    }

    public XEasyPdfPageParam setAllowBackgroundImage(boolean allowBackgroundImage) {
        this.allowBackgroundImage = allowBackgroundImage;
        return this;
    }

    public XEasyPdfPageParam setAllowHeader(boolean allowHeader) {
        this.allowHeader = allowHeader;
        return this;
    }

    public XEasyPdfPageParam setAllowFooter(boolean allowFooter) {
        this.allowFooter = allowFooter;
        return this;
    }

    public XEasyPdfPageParam setAllowResetPosition(boolean allowResetPosition) {
        this.allowResetPosition = allowResetPosition;
        return this;
    }

    public XEasyPdfPageParam setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfPageParam)) {
            return false;
        }
        XEasyPdfPageParam other = (XEasyPdfPageParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAllowWatermark() != other.isAllowWatermark()) {
            return false;
        }
        if (this.isAllowBackgroundImage() != other.isAllowBackgroundImage()) {
            return false;
        }
        if (this.isAllowHeader() != other.isAllowHeader()) {
            return false;
        }
        if (this.isAllowFooter() != other.isAllowFooter()) {
            return false;
        }
        if (this.isAllowResetPosition() != other.isAllowResetPosition()) {
            return false;
        }
        Float this$pageX = this.getPageX();
        Float other$pageX = other.getPageX();
        if (this$pageX == null ? other$pageX != null : !((Object)this$pageX).equals(other$pageX)) {
            return false;
        }
        Float this$pageY = this.getPageY();
        Float other$pageY = other.getPageY();
        if (this$pageY == null ? other$pageY != null : !((Object)this$pageY).equals(other$pageY)) {
            return false;
        }
        String this$fontPath = this.getFontPath();
        String other$fontPath = other.getFontPath();
        if (this$fontPath == null ? other$fontPath != null : !this$fontPath.equals(other$fontPath)) {
            return false;
        }
        PDFont this$font = this.getFont();
        PDFont other$font = other.getFont();
        if (this$font == null ? other$font != null : !this$font.equals(other$font)) {
            return false;
        }
        PDRectangle this$pageSize = this.getPageSize();
        PDRectangle other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !this$pageSize.equals(other$pageSize)) {
            return false;
        }
        PDRectangle this$modifyPageSize = this.getModifyPageSize();
        PDRectangle other$modifyPageSize = other.getModifyPageSize();
        if (this$modifyPageSize == null ? other$modifyPageSize != null : !this$modifyPageSize.equals(other$modifyPageSize)) {
            return false;
        }
        List<PDPage> this$pageList = this.getPageList();
        List<PDPage> other$pageList = other.getPageList();
        if (this$pageList == null ? other$pageList != null : !((Object)this$pageList).equals(other$pageList)) {
            return false;
        }
        List<PDPage> this$newPageList = this.getNewPageList();
        List<PDPage> other$newPageList = other.getNewPageList();
        if (this$newPageList == null ? other$newPageList != null : !((Object)this$newPageList).equals(other$newPageList)) {
            return false;
        }
        List<XEasyPdfComponent> this$componentList = this.getComponentList();
        List<XEasyPdfComponent> other$componentList = other.getComponentList();
        if (this$componentList == null ? other$componentList != null : !((Object)this$componentList).equals(other$componentList)) {
            return false;
        }
        XEasyPdfWatermark this$watermark = this.getWatermark();
        XEasyPdfWatermark other$watermark = other.getWatermark();
        if (this$watermark == null ? other$watermark != null : !this$watermark.equals(other$watermark)) {
            return false;
        }
        XEasyPdfImage this$backgroundImage = this.getBackgroundImage();
        XEasyPdfImage other$backgroundImage = other.getBackgroundImage();
        if (this$backgroundImage == null ? other$backgroundImage != null : !this$backgroundImage.equals(other$backgroundImage)) {
            return false;
        }
        XEasyPdfHeader this$header = this.getHeader();
        XEasyPdfHeader other$header = other.getHeader();
        if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
            return false;
        }
        XEasyPdfFooter this$footer = this.getFooter();
        XEasyPdfFooter other$footer = other.getFooter();
        if (this$footer == null ? other$footer != null : !this$footer.equals(other$footer)) {
            return false;
        }
        Color this$backgroundColor = this.getBackgroundColor();
        Color other$backgroundColor = other.getBackgroundColor();
        return !(this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfPageParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAllowWatermark() ? 79 : 97);
        result = result * 59 + (this.isAllowBackgroundImage() ? 79 : 97);
        result = result * 59 + (this.isAllowHeader() ? 79 : 97);
        result = result * 59 + (this.isAllowFooter() ? 79 : 97);
        result = result * 59 + (this.isAllowResetPosition() ? 79 : 97);
        Float $pageX = this.getPageX();
        result = result * 59 + ($pageX == null ? 43 : ((Object)$pageX).hashCode());
        Float $pageY = this.getPageY();
        result = result * 59 + ($pageY == null ? 43 : ((Object)$pageY).hashCode());
        String $fontPath = this.getFontPath();
        result = result * 59 + ($fontPath == null ? 43 : $fontPath.hashCode());
        PDFont $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : $font.hashCode());
        PDRectangle $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : $pageSize.hashCode());
        PDRectangle $modifyPageSize = this.getModifyPageSize();
        result = result * 59 + ($modifyPageSize == null ? 43 : $modifyPageSize.hashCode());
        List<PDPage> $pageList = this.getPageList();
        result = result * 59 + ($pageList == null ? 43 : ((Object)$pageList).hashCode());
        List<PDPage> $newPageList = this.getNewPageList();
        result = result * 59 + ($newPageList == null ? 43 : ((Object)$newPageList).hashCode());
        List<XEasyPdfComponent> $componentList = this.getComponentList();
        result = result * 59 + ($componentList == null ? 43 : ((Object)$componentList).hashCode());
        XEasyPdfWatermark $watermark = this.getWatermark();
        result = result * 59 + ($watermark == null ? 43 : $watermark.hashCode());
        XEasyPdfImage $backgroundImage = this.getBackgroundImage();
        result = result * 59 + ($backgroundImage == null ? 43 : $backgroundImage.hashCode());
        XEasyPdfHeader $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        XEasyPdfFooter $footer = this.getFooter();
        result = result * 59 + ($footer == null ? 43 : $footer.hashCode());
        Color $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
        return result;
    }

    public String toString() {
        return "XEasyPdfPageParam(fontPath=" + this.getFontPath() + ", font=" + this.getFont() + ", pageX=" + this.getPageX() + ", pageY=" + this.getPageY() + ", pageSize=" + this.getPageSize() + ", modifyPageSize=" + this.getModifyPageSize() + ", pageList=" + this.getPageList() + ", newPageList=" + this.getNewPageList() + ", componentList=" + this.getComponentList() + ", watermark=" + this.getWatermark() + ", backgroundImage=" + this.getBackgroundImage() + ", header=" + this.getHeader() + ", footer=" + this.getFooter() + ", allowWatermark=" + this.isAllowWatermark() + ", allowBackgroundImage=" + this.isAllowBackgroundImage() + ", allowHeader=" + this.isAllowHeader() + ", allowFooter=" + this.isAllowFooter() + ", allowResetPosition=" + this.isAllowResetPosition() + ", backgroundColor=" + this.getBackgroundColor() + ")";
    }
}

