/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.page.XEasyPdfPage;

public class XEasyPdfFontUtil {
    public static PDFont getFont(XEasyPdfDocument document, String fontPath, PDFont defaultFont) {
        if (fontPath != null) {
            return XEasyPdfFontUtil.loadFont(document, fontPath);
        }
        return defaultFont;
    }

    public static PDFont loadFont(XEasyPdfDocument document, InputStream inputStream) {
        try {
            return PDType0Font.load((PDDocument)document.getTarget(), (InputStream)inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException("the font can not be loaded");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PDFont loadFont(XEasyPdfDocument document, String fontPath) {
        try (InputStream inputStream = Files.newInputStream(Paths.get(fontPath, new String[0]), new OpenOption[0]);){
            PDType0Font pDType0Font = PDType0Font.load((PDDocument)document.getTarget(), (InputStream)inputStream);
            return pDType0Font;
        }
        catch (Exception e) {
            throw new RuntimeException("the font can not be loaded");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PDFont loadFont(XEasyPdfDocument document, XEasyPdfPage page, String fontPath) {
        if (fontPath == null) return XEasyPdfFontUtil.loadFont(document, page, (InputStream)null);
        try (InputStream inputStream = Files.newInputStream(Paths.get(fontPath, new String[0]), new OpenOption[0]);){
            PDFont pDFont = XEasyPdfFontUtil.loadFont(document, page, inputStream);
            return pDFont;
        }
        catch (Exception e) {
            throw new RuntimeException("the font can not be loaded");
        }
    }

    public static PDFont loadFont(XEasyPdfDocument document, XEasyPdfPage page, InputStream inputStream) {
        PDType0Font font = null;
        if (inputStream != null) {
            try {
                font = PDType0Font.load((PDDocument)document.getTarget(), (InputStream)inputStream);
            }
            catch (IOException ex) {
                throw new RuntimeException("the font can not be loaded");
            }
        }
        if (font == null && page != null) {
            font = page.getFont();
        }
        if (font == null && document != null) {
            font = document.getFont();
        }
        if (font == null) {
            throw new RuntimeException("the font can not be found");
        }
        return font;
    }

    public static void addToSubset(PDFont font, String text) {
        if (font.willBeSubset()) {
            int codePoint;
            int length = text.length();
            for (int offset = 0; offset < length; offset += Character.charCount(codePoint)) {
                codePoint = text.codePointAt(offset);
                font.addToSubset(codePoint);
            }
        }
    }

    public static float getFontHeight(PDFont font, float fontSize) {
        return font.getFontDescriptor().getCapHeight() / 1000.0f * fontSize;
    }
}

