/*
 * Decompiled with CFR 0.152.
 */
package win.delin.idcards;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import win.delin.idcards.Exception.IdCardCheckCodeErrorException;
import win.delin.idcards.Exception.IdCardException;
import win.delin.idcards.IdCard;
import win.delin.lunar.Lunar;
import win.delin.lunar.LunarSolarConverter;
import win.delin.lunar.Solar;

public class IdCardUtils {
    public static JSONObject locationDatas;
    private static final int CHINA_ID_MIN_LENGTH = 15;
    private static final int CHINA_ID_MAX_LENGTH = 18;
    private static final int[] POWER;
    private static final String[] VERIFY_CODE;
    private static final String[] PROVINCE_CODE;
    private static final int MIN = 1930;
    private static final String[] TIAN_GAN;
    private static final String[] DI_ZHI;
    public static final String[] ZODIAC_ARRAY;
    public static final String[] CONSTELLATION_ARRAY;
    public static final int[] CONSTELLATION_EDGE_DAY;
    private static Map<String, String> provinceCodes;

    public static IdCard getInformation(String idCardNum) throws IdCardException {
        return IdCardUtils.getInformation(idCardNum, false);
    }

    public static IdCard getInformation(String idCardNum, boolean lunar) throws IdCardException {
        IdCardUtils.validateCard(idCardNum);
        IdCard idCard = new IdCard(idCardNum);
        idCard.setArea(IdCardUtils.getArea(idCardNum));
        idCard.setProvince(IdCardUtils.getProvice(idCardNum));
        idCard.setCity(IdCardUtils.getCity(idCardNum));
        idCard.setCounty(IdCardUtils.getCounty(idCardNum));
        idCard.setGender(IdCardUtils.getGenderByIdCard(idCardNum));
        idCard.setAge(IdCardUtils.getAgeByIdCard(idCardNum, lunar));
        idCard.setZodiac(IdCardUtils.getZodica(idCardNum, lunar));
        idCard.setConstellation(IdCardUtils.getConstellation(idCardNum, lunar));
        idCard.setBirthday(IdCardUtils.getBirthByIdCardStr(idCardNum, lunar));
        idCard.setGanZhi(IdCardUtils.getGanZhiByIdCard(idCardNum, lunar));
        return idCard;
    }

    public static String getProvice(String idCardNum) {
        return locationDatas.getString(idCardNum.substring(0, 2) + "0000");
    }

    public static String getCity(String idCardNum) {
        return locationDatas.getString(idCardNum.substring(0, 4) + "00");
    }

    public static String getCounty(String idCardNum) {
        return locationDatas.getString(idCardNum.substring(0, 6));
    }

    public static String getArea(String idCardNum) {
        return IdCardUtils.getProvice(idCardNum) + IdCardUtils.getCity(idCardNum) + IdCardUtils.getCounty(idCardNum);
    }

    public static String getGenderByIdCard(String idCardNum) {
        String sCardNum;
        String sGender = "N";
        if (idCardNum.length() == 15) {
            idCardNum = IdCardUtils.conver15CardTo18(idCardNum);
        }
        sGender = Integer.parseInt(sCardNum = idCardNum.substring(16, 17)) % 2 != 0 ? "M" : "F";
        return sGender;
    }

    public static int getAgeByIdCard(String idCard, boolean isLunar) {
        int iAge = 0;
        if (idCard.length() == 15) {
            idCard = IdCardUtils.conver15CardTo18(idCard);
        }
        Calendar birthCal = IdCardUtils.getBirthByIdCard(idCard, isLunar);
        Calendar cal = Calendar.getInstance();
        int iCurrYear = cal.get(1);
        iAge = iCurrYear - birthCal.get(1);
        return iAge;
    }

    public static String getGanZhiByIdCard(String idCard, boolean isLunar) {
        if (idCard.length() == 15) {
            idCard = IdCardUtils.conver15CardTo18(idCard);
        }
        Calendar birthCal = IdCardUtils.getLunarBirthByIdCard(idCard, isLunar);
        return LunarSolarConverter.lunarYearToGanZhi(birthCal.get(1));
    }

    public static String getBirthByIdCardStr(String idCard, boolean isLunar) {
        Calendar cal = IdCardUtils.getBirthByIdCard(idCard, isLunar);
        return String.format("%s-%s-%s", cal.get(1), cal.get(2), cal.get(5));
    }

    public static Calendar getBirthByIdCard(String idCard, boolean isLunar) {
        Integer len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCard = IdCardUtils.conver15CardTo18(idCard);
        }
        int year = Integer.valueOf(idCard.substring(6, 10));
        int month = Integer.valueOf(idCard.substring(10, 12));
        int day = Integer.valueOf(idCard.substring(12, 14));
        if (isLunar) {
            Lunar lunar = new Lunar();
            lunar.lunarYear = year;
            lunar.lunarMonth = month;
            lunar.lunarDay = day;
            Solar solar = LunarSolarConverter.LunarToSolar(lunar);
            year = solar.solarYear;
            month = solar.solarMonth;
            day = solar.solarDay;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, day);
        return cal;
    }

    public static Calendar getLunarBirthByIdCard(String idCard, boolean isLunar) {
        Integer len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCard = IdCardUtils.conver15CardTo18(idCard);
        }
        int year = Integer.valueOf(idCard.substring(6, 10));
        int month = Integer.valueOf(idCard.substring(10, 12));
        int day = Integer.valueOf(idCard.substring(12, 14));
        if (!isLunar) {
            Solar solar = new Solar();
            solar.solarYear = year;
            solar.solarMonth = month;
            solar.solarDay = day;
            Lunar lunar = LunarSolarConverter.SolarToLunar(solar);
            year = lunar.lunarYear;
            month = lunar.lunarMonth;
            day = lunar.lunarDay;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, day);
        return cal;
    }

    public static String getZodica(Calendar time) {
        return ZODIAC_ARRAY[time.get(1) % 12];
    }

    public static String getZodica(String idCard, boolean lunar) {
        return IdCardUtils.getZodica(IdCardUtils.getBirthByIdCard(idCard, lunar));
    }

    public static String getZodica(String idCard) {
        return IdCardUtils.getZodica(IdCardUtils.getZodica(idCard, false));
    }

    public static String getConstellation(Calendar time) {
        int month = time.get(2);
        int day = time.get(5);
        return day < CONSTELLATION_EDGE_DAY[month - 1] ? CONSTELLATION_ARRAY[month - 1] : CONSTELLATION_ARRAY[month];
    }

    public static String getConstellation(String idCard, boolean lunar) {
        return IdCardUtils.getConstellation(IdCardUtils.getBirthByIdCard(idCard, lunar));
    }

    public static String getConstellation(String idCard) {
        return IdCardUtils.getConstellation(idCard, false);
    }

    public static Short getYearByIdCard(String idCard) {
        Integer len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCard = IdCardUtils.conver15CardTo18(idCard);
        }
        return Short.valueOf(idCard.substring(6, 10));
    }

    public static Short getMonthByIdCard(String idCard) {
        Integer len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCard = IdCardUtils.conver15CardTo18(idCard);
        }
        return Short.valueOf(idCard.substring(10, 12));
    }

    public static Short getDateByIdCard(String idCard) {
        Integer len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCard = IdCardUtils.conver15CardTo18(idCard);
        }
        return Short.valueOf(idCard.substring(12, 14));
    }

    public static boolean validateCard(String idCardNum) throws IdCardException {
        String card = idCardNum.trim();
        if (IdCardUtils.validateIdCard18(card)) {
            return true;
        }
        return IdCardUtils.validateIdCard15(card);
    }

    public static boolean validateIdCard18(String idCardNum) throws IdCardCheckCodeErrorException {
        boolean bTrue = false;
        if (idCardNum.length() == 18) {
            int[] iCard;
            int iSum17;
            String val;
            char[] cArr;
            String code17 = idCardNum.substring(0, 17);
            String code18 = idCardNum.substring(17, 18);
            if (IdCardUtils.isNum(code17) && (cArr = code17.toCharArray()) != null && (val = IdCardUtils.getCheckCode18(iSum17 = IdCardUtils.getPowerSum(iCard = IdCardUtils.converCharToInt(cArr)))).length() > 0) {
                if (val.equalsIgnoreCase(code18)) {
                    bTrue = true;
                } else {
                    throw new IdCardCheckCodeErrorException(idCardNum, val);
                }
            }
        }
        return bTrue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String conver15CardTo18(String idCardNum) {
        String idCard18 = "";
        if (idCardNum.length() != 15) {
            return null;
        }
        if (!IdCardUtils.isNum(idCardNum)) return null;
        String birthday = idCardNum.substring(6, 12);
        Date birthDate = null;
        try {
            birthDate = new SimpleDateFormat("yyMMdd").parse(birthday);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cal = Calendar.getInstance();
        if (birthDate != null) {
            cal.setTime(birthDate);
        }
        String sYear = String.valueOf(cal.get(1));
        idCard18 = idCardNum.substring(0, 6) + sYear + idCardNum.substring(8);
        char[] cArr = idCard18.toCharArray();
        if (cArr == null) return idCard18;
        int[] iCard = IdCardUtils.converCharToInt(cArr);
        int iSum17 = IdCardUtils.getPowerSum(iCard);
        String sVal = IdCardUtils.getCheckCode18(iSum17);
        if (sVal.length() <= 0) return null;
        return idCard18 + sVal;
    }

    public static boolean validateIdCard15(String idCardNum) {
        if (idCardNum.length() != 15) {
            return false;
        }
        if (IdCardUtils.isNum(idCardNum)) {
            String proCode = idCardNum.substring(0, 2);
            if (provinceCodes.get(proCode) == null) {
                return false;
            }
            String birthCode = idCardNum.substring(6, 12);
            Date birthDate = null;
            try {
                birthDate = new SimpleDateFormat("yy").parse(birthCode.substring(0, 2));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            Calendar cal = Calendar.getInstance();
            if (birthDate != null) {
                cal.setTime(birthDate);
            }
            return IdCardUtils.valiDate(cal.get(1), Integer.valueOf(birthCode.substring(2, 4)), Integer.valueOf(birthCode.substring(4, 6)));
        }
        return false;
    }

    public static boolean valiDate(int iYear, int iMonth, int iDate) {
        int datePerMonth;
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        if (iYear < 1930 || iYear >= year) {
            return false;
        }
        if (iMonth < 1 || iMonth > 12) {
            return false;
        }
        switch (iMonth) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                datePerMonth = 30;
                break;
            }
            case 2: {
                boolean dm = (iYear % 4 == 0 && iYear % 100 != 0 || iYear % 400 == 0) && iYear > 1930 && iYear < year;
                datePerMonth = dm ? 29 : 28;
                break;
            }
            default: {
                datePerMonth = 31;
            }
        }
        return iDate >= 1 && iDate <= datePerMonth;
    }

    public static boolean isNum(String val) {
        return val == null || "".equals(val) ? false : val.matches("^[0-9]*$");
    }

    public static int[] converCharToInt(char[] ca) {
        int len = ca.length;
        int[] iArr = new int[len];
        try {
            for (int i = 0; i < len; ++i) {
                iArr[i] = Integer.parseInt(String.valueOf(ca[i]));
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return iArr;
    }

    public static int getPowerSum(int[] iArr) {
        int iSum = 0;
        if (POWER.length == iArr.length) {
            for (int i = 0; i < iArr.length; ++i) {
                for (int j = 0; j < POWER.length; ++j) {
                    if (i != j) continue;
                    iSum += iArr[i] * POWER[j];
                }
            }
        }
        return iSum;
    }

    public static String getCheckCode18(int iSum) {
        String sCode = "";
        switch (iSum % 11) {
            case 10: {
                sCode = "2";
                break;
            }
            case 9: {
                sCode = "3";
                break;
            }
            case 8: {
                sCode = "4";
                break;
            }
            case 7: {
                sCode = "5";
                break;
            }
            case 6: {
                sCode = "6";
                break;
            }
            case 5: {
                sCode = "7";
                break;
            }
            case 4: {
                sCode = "8";
                break;
            }
            case 3: {
                sCode = "9";
                break;
            }
            case 2: {
                sCode = "x";
                break;
            }
            case 1: {
                sCode = "0";
                break;
            }
            case 0: {
                sCode = "1";
            }
        }
        return sCode;
    }

    private static String readFile(String path) {
        String laststr = "";
        try (FileInputStream fileInputStream = new FileInputStream(ClassLoader.getSystemResource(path).getFile());
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");){
            String tempString;
            BufferedReader reader = new BufferedReader(inputStreamReader);
            while ((tempString = reader.readLine()) != null) {
                laststr = laststr + tempString;
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return laststr;
    }

    private static JSONObject readLocationFile(String path) {
        JSONObject dataLocations = JSON.parseObject((String)IdCardUtils.readFile(path));
        return dataLocations;
    }

    static {
        POWER = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
        VERIFY_CODE = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};
        PROVINCE_CODE = new String[]{"11", "12", "13", "14", "15", "21", "22", "23", "31", "32", "33", "34", "35", "36", "37", "41", "42", "43", "44", "45", "46", "50", "51", "52", "53", "54", "61", "62", "63", "64", "65", "71", "81", "82", "91"};
        TIAN_GAN = new String[]{"\u7532", "\u4e59", "\u4e19", "\u4e01", "\u620a", "\u5df1", "\u5e9a", "\u8f9b", "\u58ec", "\u7678"};
        DI_ZHI = new String[]{"\u5b50", "\u4e11", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5"};
        ZODIAC_ARRAY = new String[]{"\u7334", "\u9e21", "\u72d7", "\u732a", "\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a"};
        CONSTELLATION_ARRAY = new String[]{"\u6469\u7faf\u5ea7", "\u6c34\u74f6\u5ea7", "\u53cc\u9c7c\u5ea7", "\u767d\u7f8a\u5ea7", "\u91d1\u725b\u5ea7", "\u53cc\u5b50\u5ea7", "\u5de8\u87f9\u5ea7", "\u72ee\u5b50\u5ea7", "\u5904\u5973\u5ea7", "\u5929\u79e4\u5ea7", "\u5929\u874e\u5ea7", "\u5c04\u624b\u5ea7", "\u6469\u7faf\u5ea7"};
        CONSTELLATION_EDGE_DAY = new int[]{20, 19, 21, 20, 21, 22, 23, 23, 23, 24, 23, 22};
        provinceCodes = new HashMap<String, String>();
        locationDatas = IdCardUtils.readLocationFile("data_location.json");
        for (Map.Entry locationData : locationDatas.entrySet()) {
            if (!"0000".equals(((String)locationData.getKey()).substring(2, 6))) continue;
            provinceCodes.put(((String)locationData.getKey()).substring(0, 2), locationData.getValue().toString());
        }
    }
}

