/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.web.component;

import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import javax.validation.ConstraintViolationException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import win.doyto.query.web.response.ErrorCode;
import win.doyto.query.web.response.ErrorCodeException;
import win.doyto.query.web.response.ErrorResponse;
import win.doyto.query.web.response.PresetErrorCode;

@ControllerAdvice
@ResponseBody
class CommonExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonExceptionHandler.class);

    CommonExceptionHandler() {
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ErrorCode httpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException e) {
        log.error("HttpRequestMethodNotSupportedException: " + e.getMessage(), e.getCause());
        return PresetErrorCode.HTTP_METHOD_NOT_SUPPORTED.build(e.getMethod());
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public ErrorCode methodArgumentTypeMismatchException(MethodArgumentTypeMismatchException e) {
        log.error("MethodArgumentTypeMismatchException: " + e.getMessage(), (Throwable)e);
        return PresetErrorCode.ARGUMENT_TYPE_MISMATCH;
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ErrorCode httpMessageNotReadableException(HttpMessageNotReadableException e) {
        log.error("HttpMessageNotReadableException: " + e.getMessage(), (Throwable)e);
        if (e.getCause() instanceof InvalidFormatException) {
            return PresetErrorCode.ARGUMENT_FORMAT_ERROR.build(((InvalidFormatException)e.getCause()).getValue());
        }
        return PresetErrorCode.REQUEST_BODY_ERROR;
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public ErrorCode maxUploadSizeExceededException(MaxUploadSizeExceededException e) {
        log.error("MaxUploadSizeExceededException: {}", (Object)e.getMessage());
        return PresetErrorCode.FILE_UPLOAD_OVER_MAX_SIZE;
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ErrorCode methodArgumentNotValidException(MethodArgumentNotValidException e) {
        log.error("MethodArgumentNotValidException: {}", (Object)e.getMessage());
        return new ErrorResponse((ErrorCode)PresetErrorCode.ARGUMENT_VALIDATION_FAILED, e.getBindingResult());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ErrorCode constraintViolationException(ConstraintViolationException e) {
        log.error("ConstraintViolationException: {}", (Object)e.getMessage());
        return new ErrorResponse((ErrorCode)PresetErrorCode.ARGUMENT_VALIDATION_FAILED, e.getConstraintViolations());
    }

    @ExceptionHandler(value={BindException.class})
    public ErrorCode bindException(BindException e) {
        log.error("BindException: {}", (Object)e.getMessage());
        return new ErrorResponse((ErrorCode)PresetErrorCode.ARGUMENT_VALIDATION_FAILED, e.getBindingResult());
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    public ErrorCode duplicateKeyException(DuplicateKeyException e) {
        log.error("DuplicateKeyException: " + e.getMessage(), (Throwable)e);
        return PresetErrorCode.DUPLICATE_KEY_EXCEPTION;
    }

    @ExceptionHandler(value={Exception.class})
    public ErrorCode exception(Exception e) {
        log.error("Unknown Exception", (Throwable)e);
        return PresetErrorCode.ERROR;
    }

    @ExceptionHandler(value={ErrorCodeException.class})
    public ErrorCode errorCodeException(ErrorCodeException e) {
        log.warn("ErrorCodeException: {}", (Object)e.getMessage());
        return e.getErrorCode();
    }
}

