/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.web.component;

import java.lang.reflect.Method;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.AbstractJackson2HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;
import win.doyto.query.web.response.ErrorCode;
import win.doyto.query.web.response.JsonBody;
import win.doyto.query.web.response.JsonResponse;

@ControllerAdvice
class JsonResponseAdvice
implements ResponseBodyAdvice<Object> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonResponseAdvice.class);

    JsonResponseAdvice() {
    }

    private static ErrorCode wrap(Object body) {
        if (body instanceof JsonResponse) {
            return (JsonResponse)body;
        }
        return ErrorCode.build(body);
    }

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        Method method = returnType.getMethod();
        Class<?> declaringClass = method.getDeclaringClass();
        if (AbstractJackson2HttpMessageConverter.class.isAssignableFrom(converterType) && (declaringClass.isAnnotationPresent(JsonBody.class) || method.isAnnotationPresent(JsonBody.class))) {
            log.debug("JsonResponse: {}.{}", (Object)declaringClass.getName(), (Object)method.getName());
            return true;
        }
        return false;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        return JsonResponseAdvice.wrap(body);
    }
}

