/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.web.component;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.SmartValidator;
import win.doyto.query.validation.CreateGroup;
import win.doyto.query.web.component.MockValidator;
import win.doyto.query.web.response.ErrorCode;
import win.doyto.query.web.response.ErrorResponse;
import win.doyto.query.web.response.PresetErrorCode;

@Component
public class ListValidator {
    @Resource
    private SmartValidator smartValidator = new MockValidator();

    public void validateList(List<?> list) {
        int errorCount = 0;
        ArrayList<BindingResult> bindingResults = new ArrayList<BindingResult>();
        for (Object r : list) {
            BeanPropertyBindingResult bindingResult = new BeanPropertyBindingResult(r, r.getClass().getSimpleName());
            this.smartValidator.validate(r, (Errors)bindingResult, new Object[]{CreateGroup.class});
            bindingResults.add((BindingResult)bindingResult);
            errorCount += bindingResult.getErrorCount();
        }
        ErrorCode.assertFalse(errorCount > 0, new ErrorResponse((ErrorCode)PresetErrorCode.ARGUMENT_VALIDATION_FAILED, bindingResults), new Object[0]);
    }
}

