/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.web.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import win.doyto.query.core.IdWrapper;
import win.doyto.query.core.PageQuery;
import win.doyto.query.entity.Persistable;
import win.doyto.query.service.DynamicService;
import win.doyto.query.service.PageList;
import win.doyto.query.util.BeanUtil;
import win.doyto.query.web.component.ListValidator;
import win.doyto.query.web.response.ErrorCode;
import win.doyto.query.web.response.JsonBody;
import win.doyto.query.web.response.PresetErrorCode;

@JsonBody
abstract class AbstractController<E extends Persistable<I>, I extends Serializable, Q extends PageQuery, R, S, W extends IdWrapper<I>> {
    @Resource
    protected ListValidator listValidator = new ListValidator();
    private final Class<E> entityClass;
    private final Class<S> responseClass;
    protected final DynamicService<E, I, Q> service;
    private final TypeReference<? extends IdWrapper<I>> typeReference;
    private static final ObjectMapper objectMapper = new ObjectMapper().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);

    public AbstractController(DynamicService<E, I, Q> service, TypeReference<? extends IdWrapper<I>> typeReference) {
        this.service = service;
        this.typeReference = typeReference;
        Type[] types = BeanUtil.getActualTypeArguments(this.getClass());
        this.entityClass = (Class)types[0];
        this.responseClass = (Class)types[4];
    }

    protected S buildResponse(E e) {
        return (S)BeanUtil.convertTo(e, this.responseClass);
    }

    protected E buildEntity(R r) {
        return (E)((Persistable)BeanUtil.convertTo(r, this.entityClass));
    }

    protected E buildEntity(E e, R r) {
        return (E)((Persistable)BeanUtil.copyTo(r, e));
    }

    protected void checkResult(E e) {
        ErrorCode.assertNotNull(e, PresetErrorCode.ENTITY_NOT_FOUND, new Object[0]);
    }

    public PageList<S> page(Q q) {
        return this.service.page(q, this::buildResponse);
    }

    public List<S> query(Q q) {
        return this.service.query(q, this::buildResponse);
    }

    public void patch(R request) {
        E e = this.buildEntity(request);
        int count = this.service.patch(e);
        ErrorCode.assertTrue(count == 1, PresetErrorCode.ENTITY_NOT_FOUND, new Object[0]);
    }

    public void update(R request) {
        IdWrapper<I> w = AbstractController.convertTo(request, this.typeReference);
        this.update(w, request);
    }

    public void update(W w, R request) {
        Persistable e = this.service.get(w);
        this.checkResult(e);
        this.buildEntity(e, request).setId(w.getId());
        this.service.update(e);
    }

    public void create(List<R> requests) {
        this.listValidator.validateList(requests);
        if (requests.size() == 1) {
            this.service.create(this.buildEntity(requests.get(0)));
        } else {
            this.service.create((Iterable)requests.stream().map(this::buildEntity).collect(Collectors.toList()), new String[0]);
        }
    }

    private static <T> T convertTo(Object source, TypeReference<T> typeReference) {
        return (T)objectMapper.readValue(objectMapper.writeValueAsBytes(source), typeReference);
    }
}

