/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.web.controller;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import win.doyto.query.core.PageQuery;
import win.doyto.query.entity.Persistable;
import win.doyto.query.service.AbstractCrudService;
import win.doyto.query.service.PageList;
import win.doyto.query.util.BeanUtil;
import win.doyto.query.validation.CreateGroup;
import win.doyto.query.validation.PageGroup;
import win.doyto.query.validation.PatchGroup;
import win.doyto.query.validation.UpdateGroup;
import win.doyto.query.web.component.ListValidator;
import win.doyto.query.web.response.ErrorCode;
import win.doyto.query.web.response.JsonBody;
import win.doyto.query.web.response.PresetErrorCode;

@JsonBody
public abstract class AbstractIQRSController<E extends Persistable<I>, I extends Serializable, Q extends PageQuery, R, S>
extends AbstractCrudService<E, I, Q> {
    @Resource
    private ListValidator listValidator = new ListValidator();
    private final Class<S> responseClass;

    public AbstractIQRSController() {
        this(4);
    }

    public AbstractIQRSController(int sTypeIndex) {
        this.responseClass = (Class)BeanUtil.getActualTypeArguments(((Object)((Object)this)).getClass())[sTypeIndex];
    }

    protected E checkResult(I id, E e) {
        ErrorCode.assertNotNull(e, PresetErrorCode.ENTITY_NOT_FOUND, this.entityClass.getSimpleName() + (":" + id).replaceAll("[\n\r\t]", " "));
        return e;
    }

    protected S buildResponse(E e) {
        return (S)BeanUtil.convertTo(e, this.responseClass);
    }

    protected E buildEntity(R r) {
        return (E)((Persistable)BeanUtil.convertTo(r, (Class)this.entityClass));
    }

    protected E buildEntity(E e, R r) {
        return (E)((Persistable)BeanUtil.copyTo(r, e));
    }

    @GetMapping
    protected PageList<S> paging(@Validated(value={PageGroup.class}) Q q) {
        return super.page(q, this::buildResponse);
    }

    @GetMapping(value={"{id}"})
    public S getById(@PathVariable I id) {
        return this.buildResponse(this.checkResult(id, super.get(id)));
    }

    @DeleteMapping(value={"{id}"})
    public S deleteById(@PathVariable I id) {
        return this.buildResponse(this.checkResult(id, super.delete(id)));
    }

    public void add(R request) {
        this.add(Collections.singletonList(request));
    }

    @PostMapping
    public void add(@RequestBody @Validated(value={CreateGroup.class}) List<R> requests) {
        this.listValidator.validateList(requests);
        if (requests.size() == 1) {
            super.create(this.buildEntity(requests.get(0)));
        } else {
            super.create((Iterable)requests.stream().map(this::buildEntity).collect(Collectors.toList()), new String[0]);
        }
    }

    @PutMapping(value={"{id}"})
    public void update(@PathVariable I id, @RequestBody @Validated(value={UpdateGroup.class}) R request) {
        Persistable e = this.get((Serializable)id);
        this.checkResult(id, e);
        this.buildEntity(e, request).setId(id);
        this.update(e);
    }

    @PatchMapping(value={"{id}"})
    public void patch(@PathVariable I id, @RequestBody @Validated(value={PatchGroup.class}) R request) {
        E e = this.buildEntity(request);
        e.setId(id);
        this.patch((Persistable)e);
    }
}

