/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.web.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Serializable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import win.doyto.query.core.IdWrapper;
import win.doyto.query.core.PageQuery;
import win.doyto.query.entity.Persistable;
import win.doyto.query.service.CrudService;
import win.doyto.query.validation.UpdateGroup;
import win.doyto.query.web.controller.AbstractController;
import win.doyto.query.web.controller.RestApi;
import win.doyto.query.web.response.JsonBody;

@JsonBody
public abstract class AbstractRestController<E extends Persistable<I>, I extends Serializable, Q extends PageQuery, R, S>
extends AbstractController<E, I, Q, R, S, IdWrapper<I>>
implements RestApi<I, Q, R, S> {
    protected final CrudService<E, I, Q> service;

    public AbstractRestController(CrudService<E, I, Q> service) {
        super(service, new TypeReference<IdWrapper.Simple<I>>(){});
        this.service = service;
    }

    @Override
    @GetMapping(value={"{id}"})
    public S get(@PathVariable I id) {
        Persistable e = this.service.get(id);
        this.checkResult(e);
        return this.buildResponse(e);
    }

    @Override
    public S delete(@PathVariable I id) {
        Persistable e = this.service.delete(id);
        this.checkResult(e);
        return this.buildResponse(e);
    }

    @Override
    @PutMapping(value={"{id}"})
    public void update(@PathVariable I id, @RequestBody @Validated(value={UpdateGroup.class}) R request) {
        super.update(IdWrapper.build(id), request);
    }
}

