/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.web.response;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import win.doyto.query.web.response.ErrorCodeException;
import win.doyto.query.web.response.JsonResponse;

public interface ErrorCode {
    public Integer getCode();

    public String getMessage();

    default public boolean isSuccess() {
        return Integer.valueOf(0).equals(this.getCode());
    }

    public static <D> JsonResponse<D> build(D data) {
        return new JsonResponse<D>().setData(data);
    }

    public static ErrorCode build(ErrorCode errorCode) {
        return ErrorCode.build(errorCode.getCode(), errorCode.getMessage());
    }

    public static ErrorCode build(String message) {
        return ErrorCode.build(-1, message);
    }

    public static ErrorCode build(Integer code, String message) {
        return new JsonResponse().setCode(code).setMessage(message);
    }

    public static void assertNotNull(Object target, ErrorCode errorCode, Object ... messages) {
        ErrorCode.assertFalse(target == null, errorCode, messages);
    }

    public static void assertTrue(boolean condition, ErrorCode errorCode, Object ... messages) {
        ErrorCode.assertFalse(!condition, errorCode, messages);
    }

    public static void assertFalse(boolean condition, ErrorCode errorCode, Object ... messages) {
        if (condition) {
            ErrorCode.fail(errorCode, messages);
        }
    }

    public static void fail(ErrorCode errorCode, Object ... messages) {
        Logger logger = LoggerFactory.getLogger(ErrorCode.class);
        if (logger.isWarnEnabled()) {
            logger.warn("[{}]{} {}", new Object[]{errorCode.getCode(), errorCode.getMessage(), StringUtils.join((Object[])messages, (String)", ")});
        }
        throw new ErrorCodeException(errorCode);
    }
}

