/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.web.response;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import lombok.Generated;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import win.doyto.query.web.response.ErrorCode;

public class ErrorResponse
implements ErrorCode {
    private ErrorCode errorCode;
    private Object hints;

    public ErrorResponse(ErrorCode errorCode, BindingResult bindingResult) {
        this.errorCode = errorCode;
        this.hints = this.buildHints(bindingResult);
    }

    public ErrorResponse(ErrorCode errorCode, List<BindingResult> bindingResults) {
        this.errorCode = errorCode;
        this.hints = bindingResults.stream().map(this::buildHints).collect(Collectors.toList());
    }

    private Map<String, String> buildHints(BindingResult bindingResult) {
        return bindingResult.getFieldErrors().stream().collect(Collectors.toMap(FieldError::getField, DefaultMessageSourceResolvable::getDefaultMessage, (a, b) -> a));
    }

    public ErrorResponse(ErrorCode errorCode, Set<ConstraintViolation<?>> constraintViolations) {
        this.errorCode = errorCode;
        HashMap<String, String> error = new HashMap<String, String>();
        for (ConstraintViolation<?> constraintViolation : constraintViolations) {
            Iterator iterator = constraintViolation.getPropertyPath().iterator();
            while (iterator.hasNext()) {
                Path.Node last = (Path.Node)iterator.next();
                if (iterator.hasNext()) continue;
                error.put(last.getName(), constraintViolation.getMessage());
            }
        }
        this.hints = error;
    }

    @Generated
    public Object getHints() {
        return this.hints;
    }

    @Override
    @Generated
    public Integer getCode() {
        return this.errorCode.getCode();
    }

    @Override
    @Generated
    public String getMessage() {
        return this.errorCode.getMessage();
    }

    @Override
    @Generated
    public boolean isSuccess() {
        return this.errorCode.isSuccess();
    }
}

