/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.web.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import win.doyto.query.web.WebMvcConfigurerAdapter;
import win.doyto.query.web.response.ErrorCode;

public class HttpUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    public static final String UNKNOWN = "unknown";
    private static final ObjectMapper objectMapper = WebMvcConfigurerAdapter.configObjectMapper(new ObjectMapper());

    public static String getHeader(HttpServletRequest request, String name) {
        String value = request.getHeader(name);
        if (value != null) {
            return value;
        }
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String n = (String)names.nextElement();
            if (!n.equalsIgnoreCase(name)) continue;
            return request.getHeader(n);
        }
        return null;
    }

    public static void writeJson(HttpServletResponse response, Object content) {
        HttpUtil.writeJson(response, objectMapper.writeValueAsString(content));
    }

    public static void writeJson(HttpServletResponse response, Enum<?> content) {
        HttpUtil.writeJson(response, content instanceof ErrorCode ? ErrorCode.build((ErrorCode)((Object)content)) : content);
    }

    public static void writeJson(HttpServletResponse response, String content) {
        response.setContentType("application/json;charset=UTF-8");
        try (PrintWriter out = response.getWriter();){
            out.print(content);
            out.flush();
        }
    }

    @Generated
    private HttpUtil() {
    }
}

