/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.cache;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.support.NoOpCache;
import win.doyto.query.cache.CacheProxy;
import win.doyto.query.cache.CacheWrapper;
import win.doyto.query.config.GlobalConfiguration;
import win.doyto.query.core.Invocable;

class DefaultCacheWrapper<V>
implements CacheWrapper<V> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultCacheWrapper.class);
    private static final int MAXIMUM_POOL_SIZE = 4;
    private static final ExecutorService executorService = new ThreadPoolExecutor(Math.min(Runtime.getRuntime().availableProcessors() / 4 + 1, 4), 4, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), new RenameThreadFactory(), new ThreadPoolExecutor.DiscardOldestPolicy());
    private Cache cache = new NoOpCache("noop");

    DefaultCacheWrapper() {
    }

    public static <V> V invoke(Cache cache, Object key, Invocable<V> invocable) {
        if (cache instanceof NoOpCache || key == null) {
            return invocable.invoke();
        }
        try {
            Cache.ValueWrapper valueWrapper = cache.get(key);
            if (valueWrapper != null) {
                return (V)valueWrapper.get();
            }
        }
        catch (Exception e) {
            log.error(String.format("Cache#get failed: [cache=%s, key=%s]", cache.getName(), key), (Throwable)e);
        }
        Object value = invocable.invoke();
        executorService.execute(() -> cache.put(key, value));
        return value;
    }

    @Override
    public void setCache(Cache cache) {
        this.cache = GlobalConfiguration.instance().isIgnoreCacheException() ? CacheProxy.wrap(cache) : cache;
    }

    @Override
    @Generated
    public Cache getCache() {
        return this.cache;
    }

    private static class RenameThreadFactory
    implements ThreadFactory {
        ThreadFactory delegate = Executors.defaultThreadFactory();

        private RenameThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.delegate.newThread(r);
            String threadName = thread.getName();
            thread.setName("doyto-cache" + threadName.substring(threadName.lastIndexOf(45)));
            return thread;
        }
    }
}

