/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.config;

import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import win.doyto.query.config.GlobalConfiguration;
import win.doyto.query.core.Dialect;

public class DoytoQueryInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final String DOYTO_QUERY_CONFIG = "doyto.query.config.";

    public void initialize(ConfigurableApplicationContext context) {
        GlobalConfiguration globalConfiguration = GlobalConfiguration.instance();
        ConfigurableEnvironment environment = context.getEnvironment();
        globalConfiguration.setMapCamelCaseToUnderscore((Boolean)environment.getProperty("doyto.query.config.map-camel-case-to-underscore", Boolean.TYPE, (Object)globalConfiguration.isMapCamelCaseToUnderscore()));
        globalConfiguration.setIgnoreCacheException((Boolean)environment.getProperty("doyto.query.config.ignore-cache-exception", Boolean.TYPE, (Object)globalConfiguration.isIgnoreCacheException()));
        String dialectClass = environment.getProperty("doyto.query.config.dialect", globalConfiguration.getDialect().getClass().getName());
        Dialect dialect = (Dialect)Class.forName(dialectClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        globalConfiguration.setDialect(dialect);
    }
}

