/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.config;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import win.doyto.query.core.Dialect;

public class MySQLDialect
implements Dialect {
    private static final String LIMIT = " LIMIT ";
    private Pattern from = Pattern.compile("FROM \\w+");
    private Pattern join = Pattern.compile("join", 2);
    private Pattern alias = Pattern.compile("(,|SELECT)\\s*([\\w*]+)");

    @Override
    public String buildPageSql(String sql, int limit, long offset) {
        if (!sql.startsWith("SELECT")) {
            return sql + LIMIT + limit;
        }
        Matcher fromMatcher = this.from.matcher(sql);
        if (!fromMatcher.find() || this.join.matcher(sql).find()) {
            return sql + LIMIT + limit + (sql.startsWith("SELECT") ? " OFFSET " + offset : "");
        }
        String fromTable = fromMatcher.group();
        int fromIndex = fromMatcher.start();
        StringBuffer start = new StringBuffer(sql.length() * 3);
        Matcher aliasMatcher = this.alias.matcher(sql.substring(0, fromIndex));
        while (aliasMatcher.find()) {
            aliasMatcher.appendReplacement(start, "$1 a.$2");
        }
        aliasMatcher.appendTail(start);
        start.append(fromTable).append(" a JOIN (SELECT id ").append(sql.substring(fromIndex)).append(LIMIT).append(limit).append(" OFFSET ").append(offset).append(") b ON a.id = b.id");
        return start.toString();
    }
}

