/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.core;

import java.util.Collection;
import java.util.List;
import javax.persistence.EnumType;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import win.doyto.query.annotation.Enumerated;
import win.doyto.query.core.CommonUtil;
import win.doyto.query.core.QuerySuffix;

final class ColumnMeta {
    final String fieldName;
    final Object value;
    final List<Object> argList;

    final String defaultSql(QuerySuffix querySuffix, String ex) {
        if (querySuffix.getOp().contains("LIKE") && this.value instanceof String && StringUtils.isBlank((CharSequence)((String)this.value))) {
            return null;
        }
        if (!ex.isEmpty()) {
            ex = " " + ex;
        }
        String columnName = querySuffix.resolveColumnName(this.fieldName);
        ColumnMeta.appendArgs(ex, this.value, this.argList);
        return CommonUtil.convertColumn(columnName) + " " + querySuffix.getOp() + ex;
    }

    private static void appendArgs(String ex, Object value, List<Object> argList) {
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (collection.isEmpty()) {
                return;
            }
            Object next = collection.iterator().next();
            if (next instanceof Enum) {
                Enumerated enumerated = next.getClass().getAnnotation(Enumerated.class);
                boolean isString = enumerated != null && enumerated.value() == EnumType.STRING;
                collection.stream().map(element -> isString ? element.toString() : Integer.valueOf(((Enum)element).ordinal())).forEach(x$0 -> argList.add(x$0));
            } else {
                argList.addAll(collection);
            }
        } else if (ex.contains("?")) {
            argList.add(value);
        }
    }

    @Generated
    public ColumnMeta(String fieldName, Object value, List<Object> argList) {
        this.fieldName = fieldName;
        this.value = value;
        this.argList = argList;
    }
}

