/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.core;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.persistence.Id;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import win.doyto.query.core.CommonUtil;
import win.doyto.query.core.IdWrapper;
import win.doyto.query.core.PageQuery;
import win.doyto.query.core.QueryBuilder;
import win.doyto.query.core.SqlAndArgs;
import win.doyto.query.core.StringJoiner;
import win.doyto.query.entity.Persistable;

final class CrudBuilder<E extends Persistable<?>>
extends QueryBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CrudBuilder.class);
    private final Field idField;
    private final List<Field> fields;
    private final int fieldsSize;
    private final String wildInsertValue;
    private final String insertColumns;
    private final String wildSetClause;

    public CrudBuilder(Class<E> entityClass) {
        super(entityClass);
        this.idField = FieldUtils.getFieldsWithAnnotation(entityClass, Id.class)[0];
        Field[] allFields = FieldUtils.getAllFields(entityClass);
        ArrayList tempFields = new ArrayList(allFields.length);
        Arrays.stream(allFields).filter(CommonUtil::fieldFilter).forEachOrdered(tempFields::add);
        this.fields = Collections.unmodifiableList(tempFields);
        this.fieldsSize = this.fields.size();
        this.wildInsertValue = CommonUtil.wrapWithParenthesis(StringUtils.join((Iterable)IntStream.range(0, this.fieldsSize).mapToObj(i -> "?").collect(Collectors.toList()), (String)", "));
        List columnList = this.fields.stream().map(CommonUtil::resolveColumn).collect(Collectors.toList());
        this.insertColumns = CommonUtil.wrapWithParenthesis(StringUtils.join(columnList, (String)", "));
        this.wildSetClause = StringUtils.join((Iterable)columnList.stream().map(c -> c + " = ?").collect(Collectors.toList()), (String)", ");
    }

    private static String buildInsertSql(String table, String columns, String fields) {
        StringJoiner insertSql = new StringJoiner(" ", 5);
        insertSql.append("INSERT INTO");
        insertSql.append(table);
        insertSql.append(columns);
        insertSql.append("VALUES");
        insertSql.append(fields);
        return insertSql.toString();
    }

    private static String buildUpdateSql(String tableName, String setClauses) {
        StringJoiner updateSql = new StringJoiner(" ", 4);
        updateSql.append("UPDATE");
        updateSql.append(tableName);
        updateSql.append("SET");
        updateSql.append(setClauses);
        return updateSql.toString();
    }

    private static void readValueToArgList(List<Field> fields, Object entity, List<Object> argList) {
        fields.stream().map(field -> CommonUtil.readFieldGetter(field, entity)).forEach(argList::add);
    }

    private static void readValueToArgList(List<Field> fields, Object entity, List<Object> argList, StringJoiner setClauses) {
        for (Field field : fields) {
            Object o = CommonUtil.readFieldGetter(field, entity);
            if (o == null) continue;
            setClauses.append(CommonUtil.resolveColumn(field) + " = ?");
            argList.add(o);
        }
    }

    public String buildCreateAndArgs(E entity, List<Object> argList) {
        String table = this.resolveTableName(entity);
        CrudBuilder.readValueToArgList(this.fields, entity, argList);
        return CrudBuilder.buildInsertSql(table, CommonUtil.replaceHolderInString(entity, this.insertColumns), this.wildInsertValue);
    }

    public SqlAndArgs buildCreateAndArgs(Iterable<E> entities, String ... columns) {
        ArrayList<Object> argList = new ArrayList<Object>();
        Iterator<E> iterator = entities.iterator();
        Persistable next = (Persistable)iterator.next();
        StringBuilder insertSql = new StringBuilder(CrudBuilder.buildInsertSql(this.resolveTableName((E)next.toIdWrapper()), this.insertColumns, this.wildInsertValue));
        CrudBuilder.readValueToArgList(this.fields, next, argList);
        while (iterator.hasNext()) {
            Persistable entity = (Persistable)iterator.next();
            CrudBuilder.readValueToArgList(this.fields, entity, argList);
            insertSql.append(", ").append(this.wildInsertValue);
        }
        if (columns.length > 0) {
            insertSql.append(" ON DUPLICATE KEY UPDATE ");
            StringJoiner stringJoiner = new StringJoiner(", ", columns.length);
            for (String column : columns) {
                stringJoiner.append(column + " = " + "VALUES (" + column + ")");
            }
            insertSql.append(stringJoiner.toString());
        }
        String sql = CommonUtil.replaceHolderInString(next, insertSql.toString());
        return new SqlAndArgs(sql, argList);
    }

    public String buildUpdateAndArgs(E entity, List<Object> argList) {
        String table = this.resolveTableName(entity);
        CrudBuilder.readValueToArgList(this.fields, entity, argList);
        argList.add(CommonUtil.readField(this.idField, entity));
        return CrudBuilder.buildUpdateSql(table, CommonUtil.replaceHolderInString(entity, this.wildSetClause)) + this.whereId;
    }

    public SqlAndArgs buildUpdateAndArgs(E entity) {
        ArrayList<Object> argList = new ArrayList<Object>();
        return new SqlAndArgs(this.buildUpdateAndArgs(entity, argList), argList);
    }

    public String buildPatchAndArgs(E entity, List<Object> argList) {
        String table = this.resolveTableName(entity);
        StringJoiner setClauses = new StringJoiner(", ", this.fieldsSize);
        CrudBuilder.readValueToArgList(this.fields, entity, argList, setClauses);
        String setClausesText = CommonUtil.replaceHolderInString(entity, setClauses.toString());
        return CrudBuilder.buildUpdateSql(table, setClausesText);
    }

    public String buildPatchAndArgsWithId(E entity, List<Object> argList) {
        String sql = this.buildPatchAndArgs(entity, argList) + this.whereId;
        argList.add(CommonUtil.readField(this.idField, entity));
        return sql;
    }

    public SqlAndArgs buildPatchAndArgsWithId(E entity) {
        ArrayList<Object> argList = new ArrayList<Object>();
        return new SqlAndArgs(this.buildPatchAndArgsWithId(entity, argList), argList);
    }

    public String buildPatchAndArgsWithQuery(E entity, Object query, List<Object> argList) {
        String sql = this.buildPatchAndArgs(entity, argList);
        return CrudBuilder.buildWhere(sql, query, argList);
    }

    public SqlAndArgs buildPatchAndArgsWithQuery(E entity, Object query) {
        ArrayList<Object> argList = new ArrayList<Object>();
        String sql = this.buildPatchAndArgsWithQuery(entity, query, argList);
        return new SqlAndArgs(sql, argList);
    }

    public String buildDeleteAndArgs(PageQuery query, List<Object> argList) {
        return CrudBuilder.build(query, argList, "DELETE", new String[0], this.tableName);
    }

    public SqlAndArgs buildDeleteAndArgs(PageQuery query) {
        ArrayList<Object> argList = new ArrayList<Object>();
        return new SqlAndArgs(this.buildDeleteAndArgs(query, argList), argList);
    }

    protected String buildDeleteById(IdWrapper<?> w) {
        return "DELETE FROM " + this.resolveTableName((E)w) + this.whereId;
    }

    protected String resolveTableName(E e) {
        return this.resolveTableName((E)e.toIdWrapper());
    }
}

