/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.core;

import java.io.Serializable;
import java.util.List;
import win.doyto.query.core.IdWrapper;
import win.doyto.query.entity.Persistable;

public interface DataAccess<E extends Persistable<I>, I extends Serializable, Q> {
    public List<E> query(Q var1);

    public long count(Q var1);

    public <V> List<V> queryColumns(Q var1, Class<V> var2, String ... var3);

    default public E get(I id) {
        return this.get(IdWrapper.build(id));
    }

    public E get(IdWrapper<I> var1);

    default public int delete(I id) {
        return this.delete((Q)IdWrapper.build(id));
    }

    public int delete(IdWrapper<I> var1);

    public int delete(Q var1);

    public void create(E var1);

    default public int batchInsert(Iterable<E> entities, String ... columns) {
        int count = 0;
        for (Persistable entity : entities) {
            this.create(entity);
            ++count;
        }
        return count;
    }

    public int update(E var1);

    public int patch(E var1);

    public int patch(E var1, Q var2);

    public List<I> queryIds(Q var1);
}

