/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.core;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import win.doyto.query.annotation.NestedQueries;
import win.doyto.query.annotation.NestedQuery;
import win.doyto.query.annotation.QueryField;
import win.doyto.query.annotation.QueryTableAlias;
import win.doyto.query.core.PageQuery;
import win.doyto.query.core.QueryBuilder;
import win.doyto.query.core.QuerySuffix;

final class FieldProcessor {
    private static final Map<Field, Processor> FIELD_PROCESSOR_MAP = new ConcurrentHashMap<Field, Processor>();
    public static final Processor EMPTY_PROCESSOR = (argList, value) -> "";

    static String resolvedNestedQueries(List<Object> argList, Object value, NestedQueries nestedQueries, Processor processor) {
        String rest = FieldProcessor.resolvedNestedQueries(nestedQueries);
        IntStream.range(0, StringUtils.countMatches((CharSequence)rest, (CharSequence)"?")).mapToObj(i -> value).forEach(argList::add);
        if (nestedQueries.appendWhere()) {
            rest = rest + processor.process(argList, value);
        }
        return nestedQueries.column() + rest + StringUtils.repeat((char)')', (int)nestedQueries.value().length);
    }

    private static String resolvedNestedQueries(NestedQueries nestedQueries) {
        StringBuilder subquery = new StringBuilder();
        String lastOp = nestedQueries.op();
        NestedQuery[] value = nestedQueries.value();
        NestedQuery nestedQuery = value[0];
        subquery.append(" ").append(lastOp).append(" (").append(FieldProcessor.getNestedQuery(nestedQuery));
        lastOp = nestedQuery.op();
        int valueLength = value.length;
        for (int i = 1; i < valueLength; ++i) {
            nestedQuery = value[i];
            subquery.append(" WHERE ").append(nestedQuery.select());
            subquery.append(" ").append(lastOp).append(" (").append(FieldProcessor.getNestedQuery(nestedQuery));
            lastOp = nestedQuery.op();
        }
        return subquery.toString();
    }

    private static String getNestedQuery(NestedQuery nestedQuery) {
        return "SELECT " + nestedQuery.select() + " FROM " + nestedQuery.from() + (nestedQuery.extra().isEmpty() ? "" : " " + nestedQuery.extra());
    }

    static void init(Field field) {
        String fieldName = field.getName();
        Class<?> fieldType = field.getType();
        Processor processor = Boolean.TYPE.isAssignableFrom(fieldType) ? EMPTY_PROCESSOR : (PageQuery.class.isAssignableFrom(fieldType) ? (argList, value) -> QueryBuilder.buildWhere("", value, argList) : new DefaultProcessor(fieldName));
        if (field.isAnnotationPresent(QueryTableAlias.class)) {
            String columnName = field.getAnnotation(QueryTableAlias.class).value();
            FIELD_PROCESSOR_MAP.put(field, (argList, value) -> QuerySuffix.buildAndSql(argList, value, columnName + "." + fieldName));
        } else if (field.isAnnotationPresent(QueryField.class)) {
            String andSQL = field.getAnnotation(QueryField.class).and();
            FIELD_PROCESSOR_MAP.put(field, (argList, value) -> {
                IntStream.range(0, StringUtils.countMatches((CharSequence)andSQL, (CharSequence)"?")).mapToObj(i -> value).forEach(argList::add);
                return andSQL;
            });
        } else if (field.isAnnotationPresent(NestedQueries.class)) {
            NestedQueries nestedQueries = field.getAnnotation(NestedQueries.class);
            FIELD_PROCESSOR_MAP.put(field, (argList, value) -> FieldProcessor.resolvedNestedQueries(argList, value, nestedQueries, processor));
        } else {
            FIELD_PROCESSOR_MAP.put(field, (argList, value) -> QuerySuffix.buildAndSql(argList, value, fieldName));
        }
    }

    static String execute(List<Object> argList, Field field, Object value) {
        return FIELD_PROCESSOR_MAP.get(field).process(argList, value);
    }

    @Generated
    private FieldProcessor() {
    }

    static class DefaultProcessor
    implements Processor {
        private String fieldName;

        @Override
        public String process(List<Object> argList, Object value) {
            return QuerySuffix.buildWhereSql(argList, value, this.fieldName);
        }

        @Generated
        public DefaultProcessor(String fieldName) {
            this.fieldName = fieldName;
        }
    }

    static interface Processor {
        public String process(List<Object> var1, Object var2);
    }
}

