/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.core;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import win.doyto.query.core.CommonUtil;
import win.doyto.query.core.CrudBuilder;
import win.doyto.query.core.DataAccess;
import win.doyto.query.core.IdWrapper;
import win.doyto.query.core.PageQuery;
import win.doyto.query.core.SqlAndArgs;
import win.doyto.query.entity.Persistable;

public final class JdbcDataAccess<E extends Persistable<I>, I extends Serializable, Q extends PageQuery>
implements DataAccess<E, I, Q> {
    private static final Map<Class<?>, RowMapper<?>> classRowMapperMap = new ConcurrentHashMap();
    private final JdbcOperations jdbcOperations;
    private final RowMapper<E> rowMapper;
    private final CrudBuilder<E> crudBuilder;
    private final String[] columnsForSelect;
    private final boolean isGeneratedId;
    private final BiConsumer<E, Number> setIdFunc;

    public JdbcDataAccess(JdbcOperations jdbcOperations, Class<E> entityClass, Class<I> idClass, RowMapper<E> rowMapper) {
        classRowMapperMap.put(entityClass, rowMapper);
        this.jdbcOperations = jdbcOperations;
        this.rowMapper = rowMapper;
        this.crudBuilder = new CrudBuilder<E>(entityClass);
        this.columnsForSelect = (String[])Arrays.stream(FieldUtils.getAllFields(entityClass)).filter(JdbcDataAccess::shouldRetain).map(CommonUtil::selectAs).toArray(String[]::new);
        Field[] idFields = FieldUtils.getFieldsWithAnnotation(entityClass, Id.class);
        boolean bl = this.isGeneratedId = idFields.length == 1 && idFields[0].isAnnotationPresent(GeneratedValue.class);
        this.setIdFunc = idClass.isAssignableFrom(Integer.class) ? (e, key) -> e.setId(key.intValue()) : (idClass.isAssignableFrom(Long.class) ? (e, key) -> e.setId(key.longValue()) : (e, key) -> e.setId(key));
    }

    private static boolean shouldRetain(Field field) {
        return !field.getName().startsWith("$") && !Modifier.isStatic(field.getModifiers()) && !field.isAnnotationPresent(Transient.class);
    }

    @Override
    public final List<E> query(Q q) {
        return this.queryColumns(q, this.rowMapper, this.columnsForSelect);
    }

    @Override
    public final <V> List<V> queryColumns(Q q, Class<V> clazz, String ... columns) {
        boolean isSingleColumn = (columns = StringUtils.join((Object[])columns, (String)", ").split("\\s*,\\s*")).length == 1;
        RowMapper localRowMapper = classRowMapperMap.computeIfAbsent(clazz, c -> isSingleColumn ? new SingleColumnRowMapper(clazz) : new BeanPropertyRowMapper(clazz));
        return this.queryColumns(q, localRowMapper, columns);
    }

    @Override
    private <V> List<V> queryColumns(Q q, RowMapper<V> rowMapper, String ... columns) {
        SqlAndArgs sqlAndArgs = this.crudBuilder.buildSelectColumnsAndArgs((PageQuery)q, columns);
        return this.jdbcOperations.query(sqlAndArgs.sql, sqlAndArgs.args, rowMapper);
    }

    @Override
    public final long count(Q q) {
        SqlAndArgs sqlAndArgs = this.crudBuilder.buildCountAndArgs((PageQuery)q);
        return (Long)this.jdbcOperations.queryForObject(sqlAndArgs.sql, sqlAndArgs.args, Long.class);
    }

    @Override
    public final int delete(Q q) {
        return this.doUpdate(this.crudBuilder.buildDeleteAndArgs((PageQuery)q));
    }

    @Override
    public final E get(IdWrapper<I> w) {
        SqlAndArgs sqlAndArgs = this.crudBuilder.buildSelectById(w, this.columnsForSelect);
        List list = this.jdbcOperations.query(sqlAndArgs.sql, sqlAndArgs.args, this.rowMapper);
        return (E)(list.isEmpty() ? null : (Persistable)list.get(0));
    }

    @Override
    public int delete(IdWrapper<I> w) {
        String sql = this.crudBuilder.buildDeleteById(w);
        SqlAndArgs.logSqlInfo(sql, Arrays.asList(w.getId()));
        return this.jdbcOperations.update(sql, new Object[]{w.getId()});
    }

    @Override
    public final void create(E e) {
        ArrayList<Object> args = new ArrayList<Object>();
        String sql = this.crudBuilder.buildCreateAndArgs(e, args);
        SqlAndArgs.logSqlInfo(sql, args);
        if (this.isGeneratedId) {
            GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
            this.jdbcOperations.update(connection -> {
                PreparedStatement ps = connection.prepareStatement(sql, 1);
                int i = 1;
                for (Object arg : args) {
                    ps.setObject(i++, arg);
                }
                return ps;
            }, (KeyHolder)keyHolder);
            this.setIdFunc.accept(e, keyHolder.getKey());
        } else {
            this.jdbcOperations.update(sql, args.toArray());
        }
    }

    @Override
    public int batchInsert(Iterable<E> entities, String ... columns) {
        if (!entities.iterator().hasNext()) {
            return 0;
        }
        return this.doUpdate(this.crudBuilder.buildCreateAndArgs(entities, columns));
    }

    private int doUpdate(SqlAndArgs sqlAndArgs) {
        return this.jdbcOperations.update(sqlAndArgs.sql, sqlAndArgs.args);
    }

    @Override
    public final int update(E e) {
        return this.doUpdate(this.crudBuilder.buildUpdateAndArgs(e));
    }

    @Override
    public final int patch(E e) {
        return this.doUpdate(this.crudBuilder.buildPatchAndArgsWithId(e));
    }

    @Override
    public final int patch(E e, Q q) {
        return this.doUpdate(this.crudBuilder.buildPatchAndArgsWithQuery(e, q));
    }

    @Override
    public List<I> queryIds(Q query) {
        SqlAndArgs sqlAndArgs = this.crudBuilder.buildSelectIdAndArgs((PageQuery)query);
        return this.jdbcOperations.query(sqlAndArgs.sql, sqlAndArgs.args, (RowMapper)new SingleColumnRowMapper());
    }

    static {
        classRowMapperMap.put(Map.class, (RowMapper<?>)new ColumnMapRowMapper());
    }
}

