/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.core;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import win.doyto.query.core.IdWrapper;
import win.doyto.query.validation.PageGroup;

public class PageQuery
implements Serializable {
    protected static final String SORT_RX = "(\\w+,(asc|desc);|field\\(\\w+(,[\\w']+)+\\);)*(\\w+,(asc|desc)|field\\(\\w+(,[\\w']+)+\\))";
    protected static final java.util.regex.Pattern SORT_PTN = java.util.regex.Pattern.compile("(\\w+,(asc|desc);|field\\(\\w+(,[\\w']+)+\\);)*(\\w+,(asc|desc)|field\\(\\w+(,[\\w']+)+\\))");
    private Integer pageNumber;
    private Integer pageSize;
    @ApiModelProperty(value="Sorting field, format: field1,desc;field2,asc;field(col,'v1','v2')")
    @Pattern(regexp="(\\w+,(asc|desc);|field\\(\\w+(,[\\w']+)+\\);)*(\\w+,(asc|desc)|field\\(\\w+(,[\\w']+)+\\))", message="Sorting field format error", groups={PageGroup.class})
    private @Pattern(regexp="(\\w+,(asc|desc);|field\\(\\w+(,[\\w']+)+\\);)*(\\w+,(asc|desc)|field\\(\\w+(,[\\w']+)+\\))", message="Sorting field format error", groups={PageGroup.class}) String sort;

    public Integer getPageNumber() {
        return this.getDefault(this.pageNumber, 0, this.pageSize == null);
    }

    public Integer getPageSize() {
        return this.getDefault(this.pageSize, 10, this.pageNumber == null);
    }

    private Integer getDefault(Integer number, int defaultValue, boolean canBeNull) {
        if (number == null) {
            if (canBeNull) {
                return null;
            }
            number = defaultValue;
        }
        return Math.max(0, number);
    }

    public int calcOffset() {
        return this.needPaging() ? this.getPageSize() * this.getPageNumber() : 0;
    }

    public boolean needPaging() {
        return this.getPageNumber() != null;
    }

    public void forcePaging() {
        if (!this.needPaging()) {
            this.setPageNumber(0);
        }
    }

    protected IdWrapper toIdWrapper() {
        return IdWrapper.build(null);
    }

    @Generated
    protected PageQuery(PageQueryBuilder<?, ?> b) {
        this.pageNumber = ((PageQueryBuilder)b).pageNumber;
        this.pageSize = ((PageQueryBuilder)b).pageSize;
        this.sort = ((PageQueryBuilder)b).sort;
    }

    @Generated
    public static PageQueryBuilder<?, ?> builder() {
        return new PageQueryBuilderImpl();
    }

    @Generated
    public String getSort() {
        return this.sort;
    }

    @Generated
    public PageQuery setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @Generated
    public PageQuery setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Generated
    public PageQuery setSort(String sort) {
        this.sort = sort;
        return this;
    }

    @Generated
    public PageQuery() {
    }

    @Generated
    public PageQuery(Integer pageNumber, Integer pageSize, String sort) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.sort = sort;
    }

    @Generated
    private static final class PageQueryBuilderImpl
    extends PageQueryBuilder<PageQuery, PageQueryBuilderImpl> {
        @Generated
        private PageQueryBuilderImpl() {
        }

        @Override
        @Generated
        protected PageQueryBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PageQuery build() {
            return new PageQuery(this);
        }
    }

    @Generated
    public static abstract class PageQueryBuilder<C extends PageQuery, B extends PageQueryBuilder<C, B>> {
        @Generated
        private Integer pageNumber;
        @Generated
        private Integer pageSize;
        @Generated
        private String sort;

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public B pageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
            return this.self();
        }

        @Generated
        public B pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this.self();
        }

        @Generated
        public B sort(String sort) {
            this.sort = sort;
            return this.self();
        }

        @Generated
        public String toString() {
            return "PageQuery.PageQueryBuilder(pageNumber=" + this.pageNumber + ", pageSize=" + this.pageSize + ", sort=" + this.sort + ")";
        }
    }
}

