/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.core;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.persistence.Id;
import javax.persistence.Table;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import win.doyto.query.config.GlobalConfiguration;
import win.doyto.query.core.CommonUtil;
import win.doyto.query.core.FieldProcessor;
import win.doyto.query.core.IdWrapper;
import win.doyto.query.core.PageQuery;
import win.doyto.query.core.SqlAndArgs;
import win.doyto.query.core.StringJoiner;

public class QueryBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryBuilder.class);
    static final Pattern PTN_REPLACE = Pattern.compile("\\w*");
    private static final Pattern PTN_SORT = Pattern.compile(",(asc|desc)", 2);
    private static final Map<Class<?>, Field[]> classFieldsMap = new ConcurrentHashMap();
    protected static final String EQUALS_REPLACE_HOLDER = " = ?";
    protected final String tableName;
    protected final String idColumn;
    protected final String whereId;
    protected final boolean isDynamicTable;

    public QueryBuilder(String tableName, String idColumn) {
        this.tableName = tableName;
        this.isDynamicTable = CommonUtil.isDynamicTable(tableName);
        this.idColumn = idColumn;
        this.whereId = " WHERE " + idColumn + EQUALS_REPLACE_HOLDER;
    }

    public QueryBuilder(Class<?> entityClass) {
        this.tableName = entityClass.getAnnotation(Table.class).name();
        this.isDynamicTable = CommonUtil.isDynamicTable(this.tableName);
        Field idField = FieldUtils.getFieldsWithAnnotation(entityClass, Id.class)[0];
        this.idColumn = CommonUtil.resolveColumn(idField);
        this.whereId = " WHERE " + this.idColumn + EQUALS_REPLACE_HOLDER;
    }

    private String build(PageQuery pageQuery, List<Object> argList, String ... columns) {
        return QueryBuilder.build(pageQuery, argList, "SELECT ", columns, this.resolveTableName(pageQuery.toIdWrapper()));
    }

    static String build(PageQuery pageQuery, List<Object> argList, String operation, String[] columns, String from) {
        String sql = QueryBuilder.buildStart(operation, columns, from);
        sql = CommonUtil.replaceHolderInString(pageQuery, sql);
        sql = QueryBuilder.buildWhere(sql, pageQuery, argList);
        if (columns.length != 1 || "count(*)" != columns[0]) {
            sql = QueryBuilder.buildOrderBy(sql, pageQuery, operation);
            sql = QueryBuilder.buildPaging(sql, pageQuery);
        }
        return sql;
    }

    static String buildStart(String operation, String[] columns, String from) {
        return operation + StringUtils.join((Object[])columns, (String)", ") + " FROM " + from;
    }

    static String buildOrderBy(String sql, PageQuery pageQuery, String operation) {
        if ("SELECT " == operation && pageQuery.getSort() != null) {
            sql = sql + " ORDER BY " + PTN_SORT.matcher(pageQuery.getSort()).replaceAll(" $1").replace(";", ", ");
        }
        return sql;
    }

    static String buildPaging(String sql, PageQuery pageQuery) {
        if (pageQuery.needPaging()) {
            sql = GlobalConfiguration.dialect().buildPageSql(sql, pageQuery.getPageSize(), pageQuery.calcOffset());
        }
        return sql;
    }

    public static String buildWhere(String sql, Object query, List<Object> argList) {
        QueryBuilder.initFields(query);
        Field[] fields = classFieldsMap.get(query.getClass());
        StringJoiner whereList = new StringJoiner(" AND ", fields.length);
        for (Field field : fields) {
            String fieldName = field.getName();
            Object value = CommonUtil.readFieldGetter(field, query);
            if (!CommonUtil.isValidValue(value, field)) continue;
            if (sql.contains("${" + fieldName + "}") && value instanceof String && PTN_REPLACE.matcher((String)value).matches()) {
                sql = sql.replaceAll("\\$\\{" + fieldName + "}", String.valueOf(value));
                continue;
            }
            String and = FieldProcessor.execute(argList, field, value);
            if (and == null) continue;
            whereList.append(and);
        }
        if (!whereList.isEmpty()) {
            sql = sql + " WHERE " + whereList.toString();
        }
        return sql;
    }

    private static void initFields(Object query) {
        Class<?> clazz = query.getClass();
        if (!classFieldsMap.containsKey(clazz)) {
            classFieldsMap.put(clazz, (Field[])Arrays.stream(clazz.getDeclaredFields()).filter(CommonUtil::fieldFilter).toArray(Field[]::new));
            for (Field field : classFieldsMap.get(clazz)) {
                FieldProcessor.init(field);
            }
        }
    }

    public String buildSelectAndArgs(PageQuery query, List<Object> argList) {
        return this.buildSelectColumnsAndArgs(query, argList, "*");
    }

    public String buildCountAndArgs(PageQuery query, List<Object> argList) {
        return this.build(query, argList, "count(*)");
    }

    public SqlAndArgs buildCountAndArgs(PageQuery query) {
        ArrayList<Object> argList = new ArrayList<Object>();
        return new SqlAndArgs(this.buildCountAndArgs(query, argList), argList);
    }

    public String buildSelectColumnsAndArgs(PageQuery query, List<Object> argList, String ... columns) {
        return this.build(query, argList, columns);
    }

    public SqlAndArgs buildSelectColumnsAndArgs(PageQuery query, String ... columns) {
        ArrayList<Object> argList = new ArrayList<Object>();
        return new SqlAndArgs(this.buildSelectColumnsAndArgs(query, argList, columns), argList);
    }

    protected SqlAndArgs buildSelectById(IdWrapper<?> idWrapper, String ... columns) {
        if (columns.length == 0) {
            columns = new String[]{"*"};
        }
        String columnStr = CommonUtil.replaceHolderInString(idWrapper, StringUtils.join((Object[])columns, (String)", "));
        String selectFrom = "SELECT " + columnStr + " FROM ";
        String sql = selectFrom + this.resolveTableName(idWrapper) + this.whereId;
        return new SqlAndArgs(sql, Collections.singletonList(idWrapper.getId()));
    }

    protected SqlAndArgs buildSelectIdAndArgs(PageQuery query) {
        return this.buildSelectColumnsAndArgs(query, this.idColumn);
    }

    protected String resolveTableName(IdWrapper<?> idWrapper) {
        return this.isDynamicTable ? CommonUtil.replaceHolderInString(idWrapper, this.tableName) : this.tableName;
    }
}

