/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import win.doyto.query.core.ColumnMeta;
import win.doyto.query.core.CommonUtil;

enum QuerySuffix {
    Not("!="),
    NotLike("NOT LIKE"),
    Start("LIKE"),
    Like("LIKE"),
    NotIn("NOT IN", Ex.COLLECTION),
    In("IN", Ex.COLLECTION),
    NotNull("IS NOT NULL", Ex.EMPTY),
    Null("IS NULL", Ex.EMPTY),
    Gt(">"),
    Ge(">="),
    Lt("<"),
    Le("<="),
    Eq("="),
    NONE("=");

    private static final Pattern SUFFIX_PTN;
    private static final Map<QuerySuffix, Function<ColumnMeta, String>> sqlFuncMap;
    private final String op;
    private final Ex ex;

    private QuerySuffix(String op) {
        this(op, Ex.REPLACE_HOLDER);
    }

    private QuerySuffix(String op, Ex ex) {
        this.op = op;
        this.ex = ex;
    }

    static QuerySuffix resolve(String fieldName) {
        Matcher matcher = SUFFIX_PTN.matcher(fieldName);
        return matcher.find() ? QuerySuffix.valueOf(matcher.group()) : NONE;
    }

    static String buildAndSql(List<Object> argList, Object value, String fieldName) {
        if (CommonUtil.containsOr(fieldName)) {
            String alias;
            int indexOfDot = fieldName.indexOf(46) + 1;
            if (indexOfDot > 0) {
                alias = fieldName.substring(0, indexOfDot);
                fieldName = fieldName.substring(indexOfDot);
            } else {
                alias = "";
            }
            Object finalValue = value;
            String andSql = Arrays.stream(CommonUtil.splitByOr(fieldName)).map(s -> QuerySuffix.buildAndSql(argList, finalValue, alias + s)).collect(Collectors.joining(" OR "));
            return CommonUtil.wrapWithParenthesis(andSql);
        }
        QuerySuffix querySuffix = QuerySuffix.resolve(fieldName);
        if (querySuffix == Like) {
            value = CommonUtil.escapeLike(String.valueOf(value));
        } else if (querySuffix == Start) {
            value = CommonUtil.escapeStart(String.valueOf(value));
        }
        return sqlFuncMap.get((Object)querySuffix).apply(new ColumnMeta(fieldName, value, argList));
    }

    static String buildWhereSql(List<Object> argList, Object value, String fieldName) {
        return " WHERE " + QuerySuffix.buildAndSql(argList, value, fieldName);
    }

    private String buildAndSql(ColumnMeta columnMeta) {
        return columnMeta.defaultSql(this, this.getEx(columnMeta.value));
    }

    String resolveColumnName(String fieldName) {
        String suffix = this.name();
        return fieldName.endsWith(suffix) ? fieldName.substring(0, fieldName.length() - suffix.length()) : fieldName;
    }

    String getEx(Object value) {
        return this.ex.getEx(value);
    }

    @Generated
    public String getOp() {
        return this.op;
    }

    @Generated
    public Ex getEx() {
        return this.ex;
    }

    static {
        sqlFuncMap = new EnumMap<QuerySuffix, Function<ColumnMeta, String>>(QuerySuffix.class);
        List suffixList = Arrays.stream(QuerySuffix.values()).filter(querySuffix -> querySuffix != NONE).map(Enum::name).collect(Collectors.toList());
        String suffixPtn = StringUtils.join(suffixList, (String)"|");
        SUFFIX_PTN = Pattern.compile("(" + suffixPtn + ")$");
        Arrays.stream(QuerySuffix.values()).forEach(querySuffix -> sqlFuncMap.put((QuerySuffix)((Object)querySuffix), querySuffix::buildAndSql));
    }

    static interface Ex {
        public static final Ex REPLACE_HOLDER = value -> "?";
        public static final Ex EMPTY = value -> "";
        public static final Ex COLLECTION = value -> {
            int size = ((Collection)value).size();
            String replaceHolders = IntStream.range(0, size).mapToObj(i -> "?").collect(Collectors.joining(", "));
            return CommonUtil.wrapWithParenthesis(StringUtils.trimToNull((String)replaceHolders));
        };

        public String getEx(Object var1);
    }
}

