/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.service;

import java.util.List;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcOperations;
import win.doyto.query.core.JoinQueryBuilder;
import win.doyto.query.core.PageQuery;
import win.doyto.query.core.SqlAndArgs;
import win.doyto.query.service.PageList;

public class JoinQueryService<E, Q extends PageQuery> {
    @Autowired
    private JdbcOperations jdbcOperations;
    private final JoinQueryBuilder joinQueryBuilder;
    private BeanPropertyRowMapper<E> beanPropertyRowMapper;

    public JoinQueryService(Class<E> entityClass) {
        this.joinQueryBuilder = new JoinQueryBuilder(entityClass);
        this.beanPropertyRowMapper = new BeanPropertyRowMapper(entityClass);
    }

    public JoinQueryService(JdbcOperations jdbcOperations, Class<E> entityClass) {
        this(entityClass);
        this.jdbcOperations = jdbcOperations;
    }

    public PageList<E> page(Q q) {
        ((PageQuery)q).forcePaging();
        return new PageList<E>(this.query(q), this.count(q));
    }

    public List<E> query(Q q) {
        SqlAndArgs sqlAndArgs = this.buildJoinSelectAndArgs(q);
        return this.jdbcOperations.query(sqlAndArgs.getSql(), this.beanPropertyRowMapper, sqlAndArgs.getArgs());
    }

    public long count(Q q) {
        SqlAndArgs sqlAndArgs = this.joinQueryBuilder.buildJoinCountAndArgs((PageQuery)q);
        return (Long)this.jdbcOperations.queryForObject(sqlAndArgs.getSql(), sqlAndArgs.getArgs(), Long.class);
    }

    public SqlAndArgs buildJoinSelectAndArgs(Q q) {
        return this.joinQueryBuilder.buildJoinSelectAndArgs((PageQuery)q);
    }

    @Generated
    public JoinQueryService(JdbcOperations jdbcOperations, JoinQueryBuilder joinQueryBuilder, BeanPropertyRowMapper<E> beanPropertyRowMapper) {
        this.jdbcOperations = jdbcOperations;
        this.joinQueryBuilder = joinQueryBuilder;
        this.beanPropertyRowMapper = beanPropertyRowMapper;
    }
}

