/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import lombok.Generated;

public class BeanUtil {
    private static final ObjectMapper objectMapper = new ObjectMapper().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private static final ObjectMapper objectMapper2 = objectMapper.copy().setSerializationInclusion(JsonInclude.Include.NON_NULL);

    public static <T> T loadJsonData(String path, TypeReference<T> typeReference) throws IOException {
        return BeanUtil.loadJsonData(typeReference.getClass().getResourceAsStream(path), typeReference);
    }

    public static <T> T loadJsonData(InputStream resourceAsStream, TypeReference<T> typeReference) throws IOException {
        return (T)objectMapper.readValue(resourceAsStream, typeReference);
    }

    public static <T> T parse(String json, TypeReference<T> typeReference) {
        return (T)objectMapper.readValue(json, typeReference);
    }

    public static <T> T convertTo(Object source, Class<T> targetType) {
        return (T)objectMapper.readValue(objectMapper.writeValueAsBytes(source), targetType);
    }

    public static <T> T copyTo(Object from, T to) {
        return (T)objectMapper.updateValue(to, from);
    }

    public static <T> T copyNonNull(Object from, T to) {
        return (T)objectMapper2.updateValue(to, from);
    }

    public static Type[] getActualTypeArguments(Class<?> clazz) {
        Type genericSuperclass = clazz;
        while (!((genericSuperclass = genericSuperclass.getGenericSuperclass()) instanceof ParameterizedType)) {
        }
        return ((ParameterizedType)genericSuperclass).getActualTypeArguments();
    }

    @Generated
    private BeanUtil() {
    }
}

