// Generated by delombok at Wed Jul 07 07:54:09 CST 2021
package win.doyto.query.config;

import win.doyto.query.core.Dialect;
import java.util.function.Function;

/**
 * GlobalConfiguration
 *
 * @author f0rb
 */
public class GlobalConfiguration {
    private boolean mapCamelCaseToUnderscore;
    private boolean ignoreCacheException = true;
    private Dialect dialect = new MySQLDialect();
    private Function<Integer, Integer> startPageNumberAdjuster;

    public static int adjustStartPageNumber(Integer page) {
        return instance().getStartPageNumberAdjuster().apply(page);
    }

    public static GlobalConfiguration instance() {
        return Singleton.instance;
    }


    private static class Singleton {
        private static final GlobalConfiguration instance = new GlobalConfiguration();

        static {
            instance.setStartPageNumberFromOne(false);
        }
    }

    public static Dialect dialect() {
        return instance().dialect;
    }

    public void setStartPageNumberFromOne(boolean startPageNumberFromOne) {
        instance().setStartPageNumberAdjuster(page -> startPageNumberFromOne ? Math.max(page - 1, 0) : page);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isMapCamelCaseToUnderscore() {
        return this.mapCamelCaseToUnderscore;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isIgnoreCacheException() {
        return this.ignoreCacheException;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Dialect getDialect() {
        return this.dialect;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Function<Integer, Integer> getStartPageNumberAdjuster() {
        return this.startPageNumberAdjuster;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMapCamelCaseToUnderscore(final boolean mapCamelCaseToUnderscore) {
        this.mapCamelCaseToUnderscore = mapCamelCaseToUnderscore;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setIgnoreCacheException(final boolean ignoreCacheException) {
        this.ignoreCacheException = ignoreCacheException;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDialect(final Dialect dialect) {
        this.dialect = dialect;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStartPageNumberAdjuster(final Function<Integer, Integer> startPageNumberAdjuster) {
        this.startPageNumberAdjuster = startPageNumberAdjuster;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private GlobalConfiguration() {
    }
}
