// Generated by delombok at Wed Jul 07 07:54:09 CST 2021
package win.doyto.query.core;

import io.swagger.annotations.ApiModelProperty;
import win.doyto.query.config.GlobalConfiguration;
import win.doyto.query.validation.PageGroup;
import java.io.Serializable;
import java.util.regex.Pattern;
import static java.lang.Math.max;

/**
 * PageQuery
 *
 * @author f0rb
 */
@SuppressWarnings("java:S3740")
public class PageQuery implements Serializable {
    @SuppressWarnings("java:S5843")
    protected static final String SORT_RX = "(\\w+,(asc|desc)|field\\(\\w+(,[\\w\']+)++\\))(;(\\w+,(asc|desc)|field\\(\\w+(,[\\w\']+)++\\)))*";
    protected static final Pattern SORT_PTN = Pattern.compile(PageQuery.SORT_RX);
    private Integer pageNumber;
    private Integer pageSize;
    @ApiModelProperty("Sorting field, format: field1,desc;field2,asc;field(col,\'v1\',\'v2\')")
    @javax.validation.constraints.Pattern(regexp = SORT_RX, message = "Sorting field format error", groups = PageGroup.class)
    private String sort;

    public Integer getPageNumber() {
        return getDefault(pageNumber, 0, pageSize == null);
    }

    public Integer getPageSize() {
        return getDefault(pageSize, 10, pageNumber == null);
    }

    private Integer getDefault(Integer number, int defaultValue, boolean canBeNull) {
        if (number == null) {
            if (canBeNull) {
                return null;
            } else {
                number = defaultValue;
            }
        }
        return max(0, number);
    }

    public int calcOffset() {
        Integer page = getPageNumber();
        return page == null ? 0 : GlobalConfiguration.adjustStartPageNumber(page) * getPageSize();
    }

    public boolean needPaging() {
        return pageNumber != null || pageSize != null;
    }

    public void forcePaging() {
        if (!needPaging()) {
            setPageNumber(0);
        }
    }

    protected IdWrapper toIdWrapper() {
        return IdWrapper.build(null);
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class PageQueryBuilder<C extends PageQuery, B extends PageQuery.PageQueryBuilder<C, B>> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer pageNumber;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer pageSize;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sort;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B pageNumber(final Integer pageNumber) {
            this.pageNumber = pageNumber;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B pageSize(final Integer pageSize) {
            this.pageSize = pageSize;
            return self();
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sort(final String sort) {
            this.sort = sort;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "PageQuery.PageQueryBuilder(pageNumber=" + this.pageNumber + ", pageSize=" + this.pageSize + ", sort=" + this.sort + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class PageQueryBuilderImpl extends PageQuery.PageQueryBuilder<PageQuery, PageQuery.PageQueryBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private PageQueryBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected PageQuery.PageQueryBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public PageQuery build() {
            return new PageQuery(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected PageQuery(final PageQuery.PageQueryBuilder<?, ?> b) {
        this.pageNumber = b.pageNumber;
        this.pageSize = b.pageSize;
        this.sort = b.sort;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static PageQuery.PageQueryBuilder<?, ?> builder() {
        return new PageQuery.PageQueryBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSort() {
        return this.sort;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PageQuery setPageNumber(final Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PageQuery setPageSize(final Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PageQuery setSort(final String sort) {
        this.sort = sort;
        return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PageQuery() {
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PageQuery(final Integer pageNumber, final Integer pageSize, final String sort) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.sort = sort;
    }
}
