// Generated by delombok at Wed Jul 07 07:54:09 CST 2021
package win.doyto.query.service;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import java.util.Arrays;
import java.util.List;

/**
 * CollectionUtil
 *
 * @author f0rb
 */
class CollectionUtil {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(CollectionUtil.class);

    public static <E> E first(List<E> iterable) {
        return first(iterable, null);
    }

    public static <E> E first(List<E> list, Object info) {
        try {
            return list.isEmpty() ? null : list.get(0);
        } finally {
            if (list.size() > 1) {
                debugRepetitiveElements(list, info);
            }
        }
    }

    static <E> void debugRepetitiveElements(List<E> list, Object info) {
        StringBuilder sb = new StringBuilder();
        int size = list.size();
        for (int i = 0, end = Math.min(3, size); i < end; i++) {
            E e = list.get(i);
            sb.append("\n").append(objectDetail(e));
        }
        if (size > 3) {
            sb.append("\n...");
        }
        log.warn("Found {} elements of {}{}", size, list.get(0).getClass(), info == null ? "" : " for query: " + objectDetail(info));
        log.warn("Repetitive elements: {}", sb.toString());
        log.warn("\n  - {}", StringUtils.join(Arrays.copyOfRange(new Exception().getStackTrace(), 1, 6), "\n  - "));
    }

    private static String objectDetail(Object target) {
        return target instanceof String ? (String) target : ToStringBuilder.reflectionToString(target, NonNullToStringStyle.NON_NULL_STYLE);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private CollectionUtil() {
    }
}
