/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.config;

import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import win.doyto.query.config.GlobalConfiguration;
import win.doyto.query.core.Dialect;

public class DoytoQueryInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final String DOYTO_QUERY_CONFIG = "doyto.query.config.";

    public void initialize(ConfigurableApplicationContext context) {
        GlobalConfiguration globalConfiguration = GlobalConfiguration.instance();
        ConfigurableEnvironment environment = context.getEnvironment();
        this.configCamelCase(globalConfiguration, environment);
        this.configIgnoreCacheException(globalConfiguration, environment);
        this.configDialect(globalConfiguration, environment);
        this.configStartPageNumber(globalConfiguration, environment);
    }

    private void configStartPageNumber(GlobalConfiguration globalConfiguration, ConfigurableEnvironment environment) {
        globalConfiguration.setStartPageNumberFromOne((Boolean)environment.getProperty(this.getKey("start-page-number-from-one"), Boolean.TYPE, (Object)false));
    }

    void configCamelCase(GlobalConfiguration globalConfiguration, ConfigurableEnvironment environment) {
        globalConfiguration.setMapCamelCaseToUnderscore((Boolean)environment.getProperty(this.getKey("map-camel-case-to-underscore"), Boolean.TYPE, (Object)globalConfiguration.isMapCamelCaseToUnderscore()));
    }

    private void configIgnoreCacheException(GlobalConfiguration globalConfiguration, ConfigurableEnvironment environment) {
        globalConfiguration.setIgnoreCacheException((Boolean)environment.getProperty(this.getKey("ignore-cache-exception"), Boolean.TYPE, (Object)globalConfiguration.isIgnoreCacheException()));
    }

    private void configDialect(GlobalConfiguration globalConfiguration, ConfigurableEnvironment environment) {
        String dialectClass = environment.getProperty(this.getKey("dialect"), globalConfiguration.getDialect().getClass().getName());
        Dialect dialect = this.newDialect(dialectClass);
        globalConfiguration.setDialect(dialect);
    }

    Dialect newDialect(String dialectClass) {
        return (Dialect)Class.forName(dialectClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private String getKey(String key) {
        return DOYTO_QUERY_CONFIG + key;
    }
}

