/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.config;

import java.util.function.Function;
import lombok.Generated;
import win.doyto.query.config.MySQLDialect;
import win.doyto.query.core.Dialect;

public class GlobalConfiguration {
    private boolean mapCamelCaseToUnderscore;
    private boolean ignoreCacheException = true;
    private Dialect dialect = new MySQLDialect();
    private Function<Integer, Integer> startPageNumberAdjuster;

    public static int adjustStartPageNumber(Integer page) {
        return GlobalConfiguration.instance().getStartPageNumberAdjuster().apply(page);
    }

    public static GlobalConfiguration instance() {
        return Singleton.instance;
    }

    public static Dialect dialect() {
        return GlobalConfiguration.instance().dialect;
    }

    public void setStartPageNumberFromOne(boolean startPageNumberFromOne) {
        GlobalConfiguration.instance().setStartPageNumberAdjuster(page -> startPageNumberFromOne ? Math.max(page - 1, 0) : page);
    }

    @Generated
    public boolean isMapCamelCaseToUnderscore() {
        return this.mapCamelCaseToUnderscore;
    }

    @Generated
    public boolean isIgnoreCacheException() {
        return this.ignoreCacheException;
    }

    @Generated
    public Dialect getDialect() {
        return this.dialect;
    }

    @Generated
    public Function<Integer, Integer> getStartPageNumberAdjuster() {
        return this.startPageNumberAdjuster;
    }

    @Generated
    public void setMapCamelCaseToUnderscore(boolean mapCamelCaseToUnderscore) {
        this.mapCamelCaseToUnderscore = mapCamelCaseToUnderscore;
    }

    @Generated
    public void setIgnoreCacheException(boolean ignoreCacheException) {
        this.ignoreCacheException = ignoreCacheException;
    }

    @Generated
    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    @Generated
    public void setStartPageNumberAdjuster(Function<Integer, Integer> startPageNumberAdjuster) {
        this.startPageNumberAdjuster = startPageNumberAdjuster;
    }

    @Generated
    private GlobalConfiguration() {
    }

    private static class Singleton {
        private static final GlobalConfiguration instance = new GlobalConfiguration();

        private Singleton() {
        }

        static {
            instance.setStartPageNumberFromOne(false);
        }
    }
}

