/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.config;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import win.doyto.query.core.Dialect;

public class MySQLDialect
implements Dialect {
    private static final String LIMIT = " LIMIT ";
    private static final String OFFSET = " OFFSET ";
    private Pattern fromPtn = Pattern.compile("FROM \\w+", 2);
    private Pattern joinPtn = Pattern.compile("JOIN", 2);
    private Pattern alias = Pattern.compile("(,|SELECT)\\s*([\\w*]+)");

    @Override
    public String buildPageSql(String sql, int limit, long offset) {
        if (!sql.startsWith("SELECT")) {
            return sql + LIMIT + limit;
        }
        if (this.joinPtn.matcher(sql).find()) {
            return sql + LIMIT + limit + OFFSET + offset;
        }
        return this.buildPageForSelect(sql, limit, offset);
    }

    private String buildPageForSelect(String sql, int limit, long offset) {
        Matcher fromMatcher = this.fromPtn.matcher(sql);
        fromMatcher.find();
        String fromTable = fromMatcher.group();
        int fromIndex = fromMatcher.start();
        StringBuffer buffer = new StringBuffer(sql.length() * 3);
        Matcher aliasMatcher = this.alias.matcher(sql.substring(0, fromIndex));
        while (aliasMatcher.find()) {
            aliasMatcher.appendReplacement(buffer, "$1 a.$2");
        }
        aliasMatcher.appendTail(buffer);
        buffer.append(fromTable).append(" a JOIN (SELECT id ").append(sql.substring(fromIndex)).append(LIMIT).append(limit).append(OFFSET).append(offset).append(") b ON a.id = b.id");
        return buffer.toString();
    }
}

