/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.core;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import win.doyto.query.config.GlobalConfiguration;
import win.doyto.query.core.CommonUtil;
import win.doyto.query.core.FieldProcessor;
import win.doyto.query.core.PageQuery;
import win.doyto.query.core.StringJoiner;

public class BuildHelper {
    private static final Pattern PTN_SORT = Pattern.compile(",(asc|desc)", 2);
    private static final Map<Class<?>, Field[]> classFieldsMap = new ConcurrentHashMap();

    static String buildStart(String[] columns, String from) {
        return "SELECT " + StringUtils.join((Object[])columns, (String)", ") + " FROM " + from;
    }

    public static String buildWhere(PageQuery query, List<Object> argList) {
        Class<?> clazz = query.getClass();
        BuildHelper.initFields(clazz);
        Field[] fields = classFieldsMap.get(clazz);
        StringJoiner whereJoiner = new StringJoiner(" AND ", fields.length);
        for (Field field : fields) {
            Object value = CommonUtil.readFieldGetter(field, query);
            if (!CommonUtil.isValidValue(value, field)) continue;
            String and = FieldProcessor.execute(field, argList, value);
            whereJoiner.append(and);
        }
        if (whereJoiner.isEmpty()) {
            return "";
        }
        return " WHERE " + whereJoiner.toString();
    }

    private static void initFields(Class<?> queryClass) {
        classFieldsMap.computeIfAbsent(queryClass, c -> {
            Field[] fields = (Field[])Arrays.stream(c.getDeclaredFields()).filter(CommonUtil::fieldFilter).toArray(Field[]::new);
            Arrays.stream(fields).forEach(FieldProcessor::init);
            return fields;
        });
    }

    static String buildOrderBy(PageQuery pageQuery) {
        if (pageQuery.getSort() == null) {
            return "";
        }
        return " ORDER BY " + PTN_SORT.matcher(pageQuery.getSort()).replaceAll(" $1").replace(";", ", ");
    }

    static String buildPaging(String sql, PageQuery pageQuery) {
        if (pageQuery.needPaging()) {
            sql = GlobalConfiguration.dialect().buildPageSql(sql, pageQuery.getPageSize(), pageQuery.calcOffset());
        }
        return sql;
    }

    @Generated
    private BuildHelper() {
    }
}

