/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.core;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Transient;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import win.doyto.query.config.GlobalConfiguration;
import win.doyto.query.core.Dialect;
import win.doyto.query.core.QuerySuffix;

class CommonUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonUtil.class);
    private static final Pattern PTN_REPLACE = Pattern.compile("\\w*");
    private static final Pattern PTN_$EX = Pattern.compile("\\$\\{(\\w+)}");
    private static final Pattern PTN_CAPITAL_CHAR = Pattern.compile("([A-Z])");
    private static final Pattern PTN_SPLIT_OR = Pattern.compile("Or(?=[A-Z])");

    static boolean isDynamicTable(String input) {
        return PTN_$EX.matcher(input).find();
    }

    static String replaceHolderInString(Object target, String input) {
        Matcher matcher = PTN_$EX.matcher(input);
        if (!matcher.find()) {
            return input;
        }
        StringBuffer sb = new StringBuffer();
        do {
            String fieldName;
            Object value;
            String replacement;
            if (!PTN_REPLACE.matcher(replacement = String.valueOf(value = CommonUtil.readFieldGetter(target, fieldName = matcher.group(1)))).matches()) continue;
            matcher.appendReplacement(sb, replacement);
        } while (matcher.find());
        return matcher.appendTail(sb).toString();
    }

    static Object readFieldGetter(Object target, String fieldName) {
        Object value;
        try {
            value = MethodUtils.invokeMethod((Object)target, (boolean)true, (String)("get" + StringUtils.capitalize((String)fieldName)));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.warn("is/get\u8c03\u7528\u5f02\u5e38 : {}-{}", (Object)e.getClass().getName(), (Object)e.getMessage());
            value = CommonUtil.readField(target, fieldName);
        }
        return value;
    }

    static Object readFieldGetter(Field field, Object target) {
        Object value;
        try {
            String fieldName = field.getName();
            String prefix = field.getType().isAssignableFrom(Boolean.TYPE) ? "is" : "get";
            value = MethodUtils.invokeMethod((Object)target, (boolean)true, (String)(prefix + StringUtils.capitalize((String)fieldName)));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.warn("is/get\u8c03\u7528\u5f02\u5e38 : {}-{}", (Object)e.getClass().getName(), (Object)e.getMessage());
            value = CommonUtil.readField(field, target);
        }
        if (value instanceof Enum) {
            Enumerated enumerated = field.getAnnotation(Enumerated.class);
            value = enumerated != null && enumerated.value() == EnumType.STRING ? value.toString() : Integer.valueOf(((Enum)value).ordinal());
        }
        return value;
    }

    static Object readField(Field field, Object target) {
        return FieldUtils.readField((Field)field, (Object)target, (boolean)true);
    }

    static Object readField(Object target, String fieldName) {
        return CommonUtil.readField(CommonUtil.getField(target, fieldName), target);
    }

    static Field getField(Object target, String fieldName) {
        Field field = FieldUtils.getField(target.getClass(), (String)fieldName, (boolean)true);
        if (field == null) {
            log.warn("Field [{}] not found", (Object)fieldName);
        }
        return field;
    }

    static void writeField(Field field, Object target, Object value) {
        FieldUtils.writeField((Field)field, (Object)target, (Object)value, (boolean)true);
    }

    public static boolean fieldFilter(Field field) {
        return !field.getName().startsWith("$") && !Modifier.isStatic(field.getModifiers()) && !field.isAnnotationPresent(GeneratedValue.class) && !field.isAnnotationPresent(Transient.class);
    }

    static String wrapWithParenthesis(String input) {
        return "(" + input + ")";
    }

    static String escapeLike(String like) {
        return StringUtils.isBlank((CharSequence)like) ? like : "%" + CommonUtil.escape(like) + "%";
    }

    static String escapeStart(String like) {
        return StringUtils.isBlank((CharSequence)like) ? like : CommonUtil.escape(like) + "%";
    }

    private static String escape(String like) {
        return like.replaceAll("[%|_]", "\\\\$0");
    }

    static String convertColumn(String columnName) {
        return GlobalConfiguration.instance().isMapCamelCaseToUnderscore() ? CommonUtil.camelCaseToUnderscore(columnName) : columnName;
    }

    private static String camelCaseToUnderscore(String camel) {
        return PTN_CAPITAL_CHAR.matcher(camel).replaceAll("_$1").toLowerCase();
    }

    static boolean isValidValue(Object value, Field field) {
        return value != null && (!(value instanceof Boolean) || !field.getType().isPrimitive() || !Boolean.FALSE.equals(value)) && !QuerySuffix.resolve(field.getName()).shouldIgnore(value);
    }

    static String camelize(String or) {
        return or.substring(0, 1).toLowerCase() + or.substring(1);
    }

    static String[] splitByOr(String columnName) {
        return (String[])Arrays.stream(PTN_SPLIT_OR.split(columnName, 0)).map(CommonUtil::camelize).toArray(String[]::new);
    }

    static boolean containsOr(String input) {
        return PTN_SPLIT_OR.matcher(input).find();
    }

    static String toCamelCase(String input) {
        String[] parts = input.split("_");
        StringBuilder result = new StringBuilder(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            result.append(StringUtils.capitalize((String)parts[i]));
        }
        return result.toString();
    }

    static String resolveColumn(Field field) {
        Column column = field.getAnnotation(Column.class);
        String columnName = column != null && !column.name().isEmpty() ? column.name() : CommonUtil.convertColumn(field.getName());
        return GlobalConfiguration.dialect().wrapLabel(columnName);
    }

    static String selectAs(Field field) {
        Dialect dialect;
        String fieldName;
        String columnName = CommonUtil.resolveColumn(field);
        return columnName.equalsIgnoreCase(fieldName = (dialect = GlobalConfiguration.dialect()).wrapLabel(field.getName())) ? columnName : columnName + " AS " + fieldName;
    }

    static boolean isSingleColumn(String ... columns) {
        return columns.length == 1 && !columns[0].contains(",");
    }

    @Generated
    private CommonUtil() {
    }
}

