/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.core;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import win.doyto.query.annotation.NestedQueries;
import win.doyto.query.annotation.NestedQuery;
import win.doyto.query.annotation.QueryField;
import win.doyto.query.annotation.QueryTableAlias;
import win.doyto.query.core.BuildHelper;
import win.doyto.query.core.CommonUtil;
import win.doyto.query.core.PageQuery;
import win.doyto.query.core.QuerySuffix;

final class FieldProcessor {
    private static final Map<Field, Processor> FIELD_PROCESSOR_MAP = new ConcurrentHashMap<Field, Processor>();
    public static final Processor EMPTY_PROCESSOR = (argList, value) -> "";

    public static String execute(Field field, List<Object> argList, Object value) {
        return FIELD_PROCESSOR_MAP.get(field).process(argList, value);
    }

    public static void init(Field field) {
        Processor processor = field.isAnnotationPresent(QueryTableAlias.class) ? FieldProcessor.initFieldAnnotatedByQueryTableAlias(field) : (field.isAnnotationPresent(QueryField.class) ? FieldProcessor.initFieldAnnotatedByQueryField(field) : (field.isAnnotationPresent(NestedQueries.class) ? FieldProcessor.initFieldAnnotatedByNestedQueries(field) : FieldProcessor.initCommonField(field)));
        FIELD_PROCESSOR_MAP.put(field, processor);
    }

    private static Processor initCommonField(Field field) {
        String fieldName = field.getName();
        return FieldProcessor.chooseProcessorForFieldWithOr(fieldName);
    }

    private static Processor initFieldAnnotatedByQueryTableAlias(Field field) {
        String fieldName = field.getName();
        String tableAlias = field.getAnnotation(QueryTableAlias.class).value();
        String fieldNameWithAlias = tableAlias + "." + fieldName;
        return FieldProcessor.chooseProcessorForFieldWithOr(fieldNameWithAlias);
    }

    private static Processor chooseProcessorForFieldWithOr(String fieldName) {
        if (CommonUtil.containsOr(fieldName)) {
            return (argList, value) -> QuerySuffix.buildConditionForFieldContainsOr(fieldName, argList, value);
        }
        return (argList, value) -> QuerySuffix.buildConditionForField(fieldName, argList, value);
    }

    private static Processor initFieldAnnotatedByQueryField(Field field) {
        String andSQL = field.getAnnotation(QueryField.class).and();
        int holderCount = StringUtils.countMatches((CharSequence)andSQL, (CharSequence)"?");
        return (argList, value) -> {
            for (int i = 0; i < holderCount; ++i) {
                argList.add(value);
            }
            return andSQL;
        };
    }

    private static Processor initFieldAnnotatedByNestedQueries(Field field) {
        NestedQueries nestedQueries = field.getAnnotation(NestedQueries.class);
        Processor processor = FieldProcessor.chooseProcessorForNestedQuery(field);
        return (argList, value) -> FieldProcessor.resolvedNestedQueries(argList, value, nestedQueries, processor);
    }

    protected static Processor chooseProcessorForNestedQuery(Field field) {
        String fieldName;
        Class<?> fieldType = field.getType();
        Processor processor = Boolean.TYPE.isAssignableFrom(fieldType) ? EMPTY_PROCESSOR : (PageQuery.class.isAssignableFrom(fieldType) ? (argList, value) -> BuildHelper.buildWhere((PageQuery)value, argList) : (CommonUtil.containsOr(fieldName = field.getName()) ? (argList, value) -> " WHERE " + QuerySuffix.buildConditionForFieldContainsOr(fieldName, argList, value) : (argList, value) -> " WHERE " + QuerySuffix.buildConditionForField(fieldName, argList, value)));
        return processor;
    }

    protected static String resolvedNestedQueries(List<Object> argList, Object value, NestedQueries nestedQueries, Processor processor) {
        StringBuilder subquery = FieldProcessor.resolvedNestedQueries(nestedQueries);
        IntStream.range(0, StringUtils.countMatches((CharSequence)subquery, (CharSequence)"?")).mapToObj(i -> value).forEach(argList::add);
        if (nestedQueries.appendWhere()) {
            subquery.append(processor.process(argList, value));
        }
        return nestedQueries.column() + subquery + StringUtils.repeat((char)')', (int)nestedQueries.value().length);
    }

    private static StringBuilder resolvedNestedQueries(NestedQueries nestedQueries) {
        StringBuilder nestedQueryBuilder = new StringBuilder();
        String lastOp = nestedQueries.op();
        String lastWhere = nestedQueries.column();
        NestedQuery[] nestedQueryArr = nestedQueries.value();
        for (int i = 0; i < nestedQueryArr.length; ++i) {
            NestedQuery nestedQuery = nestedQueryArr[i];
            if (i > 0) {
                nestedQueryBuilder.append(" WHERE ").append((String)StringUtils.defaultIfBlank((CharSequence)lastWhere, (CharSequence)nestedQuery.select()));
            }
            nestedQueryBuilder.append(" ").append(lastOp).append(" (").append(FieldProcessor.getNestedQuery(nestedQuery));
            lastOp = nestedQuery.op();
            lastWhere = nestedQuery.where();
        }
        return nestedQueryBuilder;
    }

    private static String getNestedQuery(NestedQuery nestedQuery) {
        return "SELECT " + nestedQuery.select() + " FROM " + nestedQuery.from() + (String)StringUtils.defaultIfBlank((CharSequence)(" " + nestedQuery.extra()), (CharSequence)"");
    }

    @Generated
    private FieldProcessor() {
    }

    static interface Processor {
        public String process(List<Object> var1, Object var2);
    }
}

