/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.core;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Table;
import org.apache.commons.lang3.SerializationUtils;
import win.doyto.query.annotation.Joins;
import win.doyto.query.core.BuildHelper;
import win.doyto.query.core.CommonUtil;
import win.doyto.query.core.PageQuery;
import win.doyto.query.core.SqlAndArgs;
import win.doyto.query.core.StringJoiner;

public class JoinQueryBuilder {
    private static final Pattern PTN_PLACE_HOLDER = Pattern.compile("#\\{(\\w+)}");
    protected final String tableName;
    protected String[] columnsForSelect;
    private Class<?> entityClass;
    private String joinSql;

    public JoinQueryBuilder(Class<?> entityClass) {
        this.entityClass = entityClass;
        this.tableName = entityClass.getAnnotation(Table.class).name();
        this.columnsForSelect = (String[])Arrays.stream(entityClass.getDeclaredFields()).filter(CommonUtil::fieldFilter).map(CommonUtil::selectAs).toArray(String[]::new);
        this.joinSql = this.buildJoinSql();
    }

    private String buildJoinSql() {
        Joins.Join[] joins = this.entityClass.getAnnotation(Joins.class).value();
        StringJoiner joiner = new StringJoiner(" ", joins.length);
        Arrays.stream(joins).map(Joins.Join::value).forEachOrdered(joiner::append);
        return joiner.toString();
    }

    private static String resolveJoin(Object query, List<Object> argList, String join) {
        Matcher matcher = PTN_PLACE_HOLDER.matcher(join);
        StringBuffer sb = new StringBuffer(" ");
        while (matcher.find()) {
            String fieldName = matcher.group(1);
            Field field = CommonUtil.getField(query, fieldName);
            Object value = CommonUtil.readField(field, query);
            argList.add(value);
            CommonUtil.writeField(field, query, null);
            matcher.appendReplacement(sb, "?");
        }
        return matcher.appendTail(sb).toString();
    }

    private String build(PageQuery pageQuery, List<Object> argList, String ... columns) {
        pageQuery = (PageQuery)SerializationUtils.clone((Serializable)pageQuery);
        String join = JoinQueryBuilder.resolveJoin(pageQuery, argList, this.joinSql);
        String from = this.tableName + join;
        String sql = BuildHelper.buildStart(columns, from);
        sql = sql + BuildHelper.buildWhere(pageQuery, argList);
        Joins joins = this.entityClass.getAnnotation(Joins.class);
        if (!joins.groupBy().isEmpty()) {
            sql = sql + " GROUP BY " + joins.groupBy();
        }
        if (!joins.having().isEmpty()) {
            sql = sql + " HAVING " + joins.having();
        }
        if (columns.length != 1 || "count(*)" != columns[0]) {
            sql = sql + BuildHelper.buildOrderBy(pageQuery);
            sql = BuildHelper.buildPaging(sql, pageQuery);
        }
        return sql;
    }

    public SqlAndArgs buildJoinSelectAndArgs(PageQuery query) {
        return SqlAndArgs.buildSqlWithArgs(argList -> this.build(query, (List<Object>)argList, this.columnsForSelect));
    }

    public SqlAndArgs buildJoinCountAndArgs(PageQuery query) {
        return SqlAndArgs.buildSqlWithArgs(argList -> this.build(query, (List<Object>)argList, "count(*)"));
    }
}

