/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.core;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import lombok.Generated;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import win.doyto.query.annotation.NestedQueries;
import win.doyto.query.core.CommonUtil;
import win.doyto.query.core.DataAccess;
import win.doyto.query.core.IdWrapper;
import win.doyto.query.core.PageQuery;
import win.doyto.query.core.QuerySuffix;
import win.doyto.query.entity.Persistable;
import win.doyto.query.util.BeanUtil;

public class MemoryDataAccess<E extends Persistable<I>, I extends Serializable, Q extends PageQuery>
implements DataAccess<E, I, Q> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MemoryDataAccess.class);
    protected static final Map<Class<?>, Map<?, ?>> tableMap = new ConcurrentHashMap();
    protected final Map<I, E> entitiesMap = new ConcurrentHashMap<I, E>();
    private final AtomicLong idGenerator = new AtomicLong(0L);
    private final List<Field> fields;
    private final Field idField;
    private final Class<I> idFieldType;

    public MemoryDataAccess(Class<E> entityClass) {
        tableMap.put(entityClass, this.entitiesMap);
        Field[] allFields = FieldUtils.getAllFields(entityClass);
        ArrayList tempFields = new ArrayList(allFields.length);
        Arrays.stream(allFields).filter(CommonUtil::fieldFilter).forEachOrdered(tempFields::add);
        this.fields = Collections.unmodifiableList(tempFields);
        Field[] idFields = FieldUtils.getFieldsWithAnnotation(entityClass, Id.class);
        if (idFields.length == 1 && idFields[0].isAnnotationPresent(GeneratedValue.class)) {
            Class<?> type;
            this.idField = idFields[0];
            try {
                type = (Class<?>)BeanUtil.getActualTypeArguments(entityClass)[0];
            }
            catch (ClassCastException e) {
                type = this.idField.getType();
            }
            this.idFieldType = type;
        } else {
            this.idField = null;
            this.idFieldType = null;
        }
    }

    protected void generateNewId(E entity) {
        try {
            Object newId = this.chooseIdValue(this.idGenerator.incrementAndGet(), this.idFieldType);
            CommonUtil.writeField(this.idField, entity, newId);
        }
        catch (Exception e) {
            log.warn("\u5199\u5165id\u5931\u8d25: {} - {}", entity.getClass(), (Object)e.getMessage());
        }
    }

    private Object chooseIdValue(Long newId, Class<?> type) {
        Number t = newId;
        if (type.isAssignableFrom(Integer.class)) {
            t = newId.intValue();
        }
        return t;
    }

    @Override
    public E get(IdWrapper<I> idWrapper) {
        return (E)((Persistable)SerializationUtils.clone((Serializable)((Serializable)this.entitiesMap.get(idWrapper.getId()))));
    }

    @Override
    public List<I> queryIds(Q query) {
        return this.queryColumns(query, this.idFieldType, "id");
    }

    @Override
    public void create(E e) {
        if (this.idField != null) {
            this.generateNewId(e);
        }
        this.entitiesMap.put(e.getId(), e);
    }

    @Override
    public int update(E e) {
        return this.entitiesMap.put(e.getId(), e) == null ? 0 : 1;
    }

    @Override
    public int patch(E patch) {
        Persistable origin = (Persistable)this.entitiesMap.get(patch.getId());
        if (origin == null) {
            return 0;
        }
        for (Field field : this.fields) {
            Object value = CommonUtil.readField(field, patch);
            if (value == null) continue;
            CommonUtil.writeField(field, origin, value);
        }
        return 1;
    }

    @Override
    public int patch(E p, Q q) {
        List<E> list = this.query(q);
        for (Persistable origin : list) {
            p.setId(origin.getId());
            this.patch(p);
        }
        return list.size();
    }

    @Override
    public int delete(IdWrapper<I> idWrapper) {
        return this.entitiesMap.remove(idWrapper.getId()) == null ? 0 : 1;
    }

    @Override
    public int delete(Q query) {
        List<E> list = this.query(query);
        list.stream().map(Persistable::getId).forEach(this.entitiesMap::remove);
        return list.size();
    }

    protected boolean filterByQuery(Q query, E entity) {
        for (Field field : query.getClass().getDeclaredFields()) {
            Object value;
            if (!this.supportFilter(field) || !CommonUtil.isValidValue(value = CommonUtil.readField(field, query), field) || !this.shouldDiscard(entity, field.getName(), value)) continue;
            return false;
        }
        return true;
    }

    private boolean supportFilter(Field field) {
        return CommonUtil.fieldFilter(field) && !field.isAnnotationPresent(NestedQueries.class);
    }

    protected boolean shouldDiscard(E entity, String queryFieldName, Object queryFieldValue) {
        Object entityFieldValue;
        if (CommonUtil.containsOr(queryFieldName)) {
            boolean result = true;
            for (String fieldName : CommonUtil.splitByOr(queryFieldName)) {
                result &= this.shouldDiscard(entity, fieldName, queryFieldValue);
            }
            return result;
        }
        QuerySuffix querySuffix = QuerySuffix.resolve(queryFieldName);
        String columnName = querySuffix.resolveColumnName(queryFieldName);
        FilterExecutor.Matcher matcher = FilterExecutor.get(querySuffix);
        return !matcher.match(queryFieldValue, entityFieldValue = CommonUtil.readField(entity, columnName));
    }

    @Override
    public List<E> query(Q query) {
        List queryList = this.entitiesMap.values().stream().filter(item -> this.filterByQuery(query, item)).collect(Collectors.toList());
        if (((PageQuery)query).getSort() != null) {
            this.doSort(queryList, ((PageQuery)query).getSort());
        }
        if (((PageQuery)query).needPaging()) {
            queryList = this.truncateByPaging(queryList, (PageQuery)query);
        }
        return queryList;
    }

    private List<E> truncateByPaging(List<E> queryList, PageQuery pageQuery) {
        int end;
        int from = pageQuery.calcOffset();
        if (from <= (end = Math.min(queryList.size(), from + pageQuery.getPageSize()))) {
            queryList = queryList.subList(from, end);
        }
        return queryList;
    }

    @Override
    public <V> List<V> queryColumns(Q q, Class<V> classV, String ... columns) {
        List<E> entities = this.query(q);
        ArrayList<V> objects = new ArrayList<V>(entities.size());
        if (columns.length == 1) {
            return entities.stream().map(entity -> CommonUtil.readField(entity, columns[0])).collect(Collectors.toList());
        }
        for (Persistable e : entities) {
            objects.add(BeanUtil.convertTo((Object)e, classV));
        }
        return objects;
    }

    protected void doSort(List<E> queryList, String sort) {
        String[] orders = sort.split(";");
        for (int i = orders.length - 1; i >= 0; --i) {
            String order = orders[i];
            queryList.sort((o1, o2) -> {
                String[] pd = order.split(",");
                String property = CommonUtil.toCamelCase(pd[0]);
                Comparable c1 = (Comparable)CommonUtil.readField(o1, property);
                Object c2 = CommonUtil.readField(o2, property);
                int ret = c1.compareTo(c2);
                return "asc".equalsIgnoreCase(pd[1]) ? ret : -ret;
            });
        }
    }

    @Override
    public long count(Q query) {
        return this.entitiesMap.values().stream().filter(item -> this.filterByQuery(query, item)).count();
    }

    private static class FilterExecutor {
        static final Map<QuerySuffix, Matcher> map = new EnumMap<QuerySuffix, Matcher>(QuerySuffix.class);

        private FilterExecutor() {
        }

        static Matcher get(QuerySuffix querySuffix) {
            return map.getOrDefault((Object)querySuffix, Object::equals);
        }

        static {
            map.put(QuerySuffix.Like, new LikeMatcher());
            map.put(QuerySuffix.NotLike, new NotLikeMatcher());
            map.put(QuerySuffix.Start, new StartMatcher());
            map.put(QuerySuffix.Null, new NullMatcher());
            map.put(QuerySuffix.NotNull, new NotNullMatcher());
            map.put(QuerySuffix.In, (qv, ev) -> ((Collection)qv).contains(ev));
            map.put(QuerySuffix.NotIn, (qv, ev) -> !((Collection)qv).contains(ev));
            map.put(QuerySuffix.Gt, (qv, ev) -> ((Comparable)ev).compareTo(qv) > 0);
            map.put(QuerySuffix.Lt, (qv, ev) -> ((Comparable)ev).compareTo(qv) < 0);
            map.put(QuerySuffix.Ge, (qv, ev) -> ((Comparable)ev).compareTo(qv) >= 0);
            map.put(QuerySuffix.Le, (qv, ev) -> ((Comparable)ev).compareTo(qv) <= 0);
            map.put(QuerySuffix.Not, (qv, ev) -> !qv.equals(ev));
        }

        static interface Matcher {
            public boolean doMatch(Object var1, Object var2);

            default public boolean match(Object qv, Object ev) {
                return this.isComparable(qv, ev) && this.doMatch(qv, ev);
            }

            default public boolean isComparable(Object qv, Object ev) {
                return qv instanceof Collection || qv instanceof Comparable && ev instanceof Comparable;
            }
        }

        static class NullMatcher
        extends NotNullMatcher {
            NullMatcher() {
            }

            @Override
            public boolean doMatch(Object qv, Object ev) {
                return !super.doMatch(qv, ev);
            }
        }

        static class NotNullMatcher
        implements Matcher {
            NotNullMatcher() {
            }

            @Override
            public boolean doMatch(Object qv, Object ev) {
                return ev != null;
            }

            @Override
            public boolean isComparable(Object qv, Object ev) {
                return true;
            }
        }

        static class StartMatcher
        extends LikeMatcher {
            StartMatcher() {
            }

            @Override
            public boolean doMatch(Object qv, Object ev) {
                return StringUtils.startsWith((CharSequence)ev.toString(), (CharSequence)qv.toString());
            }
        }

        static class NotLikeMatcher
        extends LikeMatcher {
            NotLikeMatcher() {
            }

            @Override
            public boolean doMatch(Object qv, Object ev) {
                return !super.doMatch(qv, ev);
            }
        }

        static class LikeMatcher
        implements Matcher {
            LikeMatcher() {
            }

            @Override
            public boolean doMatch(Object qv, Object ev) {
                return StringUtils.contains((CharSequence)ev.toString(), (CharSequence)qv.toString());
            }

            @Override
            public boolean isComparable(Object qv, Object ev) {
                return ev instanceof String;
            }
        }
    }
}

