/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.core;

import java.util.List;
import java.util.function.BiFunction;
import javax.persistence.Id;
import javax.persistence.Table;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import win.doyto.query.core.BuildHelper;
import win.doyto.query.core.CommonUtil;
import win.doyto.query.core.IdWrapper;
import win.doyto.query.core.PageQuery;
import win.doyto.query.core.SqlAndArgs;

public class QueryBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryBuilder.class);
    protected static final String EQUALS_PLACE_HOLDER = " = ?";
    protected final String tableName;
    protected final String idColumn;
    protected final String whereId;
    private final BiFunction<IdWrapper<?>, String, String> resolveTableNameFunc;

    public QueryBuilder(String tableName, String idColumn) {
        this.tableName = tableName;
        this.idColumn = idColumn;
        this.whereId = " WHERE " + idColumn + EQUALS_PLACE_HOLDER;
        this.resolveTableNameFunc = CommonUtil.isDynamicTable(tableName) ? CommonUtil::replaceHolderInString : (idWrapper, tableName1) -> tableName1;
    }

    public QueryBuilder(Class<?> entityClass) {
        this(QueryBuilder.resolveTableName(entityClass), QueryBuilder.resolveIdColumn(entityClass));
    }

    private static String resolveTableName(Class<?> entityClass) {
        return entityClass.getAnnotation(Table.class).name();
    }

    private static String resolveIdColumn(Class<?> entityClass) {
        return CommonUtil.resolveColumn(FieldUtils.getFieldsWithAnnotation(entityClass, Id.class)[0]);
    }

    protected String resolveTableName(IdWrapper<?> idWrapper) {
        return this.resolveTableNameFunc.apply(idWrapper, this.tableName);
    }

    private String build(PageQuery pageQuery, List<Object> argList, String ... columns) {
        String sql = BuildHelper.buildStart(columns, this.resolveTableName(pageQuery.toIdWrapper()));
        sql = CommonUtil.replaceHolderInString(pageQuery, sql);
        sql = sql + BuildHelper.buildWhere(pageQuery, argList);
        if (columns.length != 1 || "count(*)" != columns[0]) {
            sql = sql + BuildHelper.buildOrderBy(pageQuery);
            sql = BuildHelper.buildPaging(sql, pageQuery);
        }
        return sql;
    }

    String buildSelectAndArgs(PageQuery query, List<Object> argList) {
        return this.build(query, argList, "*");
    }

    public SqlAndArgs buildCountAndArgs(PageQuery query) {
        return SqlAndArgs.buildSqlWithArgs(argList -> this.build(query, (List<Object>)argList, "count(*)"));
    }

    public SqlAndArgs buildSelectColumnsAndArgs(PageQuery query, String ... columns) {
        return SqlAndArgs.buildSqlWithArgs(argList -> this.build(query, (List<Object>)argList, columns));
    }

    public SqlAndArgs buildSelectById(IdWrapper<?> idWrapper, String ... columns) {
        return SqlAndArgs.buildSqlWithArgs(argList -> {
            argList.add(idWrapper.getId());
            String columnStr = this.buildColumnStr(idWrapper, columns);
            String table = this.resolveTableName(idWrapper);
            return "SELECT " + columnStr + " FROM " + table + this.whereId;
        });
    }

    private String buildColumnStr(IdWrapper<?> idWrapper, String[] columns) {
        String columnStr = columns.length == 0 ? "*" : CommonUtil.replaceHolderInString(idWrapper, StringUtils.join((Object[])columns, (String)", "));
        return columnStr;
    }

    protected SqlAndArgs buildSelectIdAndArgs(PageQuery query) {
        return this.buildSelectColumnsAndArgs(query, this.idColumn);
    }
}

