/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.persistence.EnumType;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import win.doyto.query.annotation.Enumerated;
import win.doyto.query.core.CommonUtil;

enum QuerySuffix {
    Not("!="),
    NotLike("NOT LIKE", ValueProcessor.LIKE_VALUE_PROCESSOR),
    Like("LIKE", ValueProcessor.LIKE_VALUE_PROCESSOR),
    Start("LIKE", new LikeValueProcessor(){

        @Override
        public Object escapeValue(Object value) {
            return CommonUtil.escapeStart(String.valueOf(value));
        }
    }),
    NotIn("NOT IN", new InValueProcessor(){

        @Override
        public boolean shouldIgnore(Object value) {
            return super.shouldIgnore(value) || ((Collection)value).isEmpty();
        }
    }),
    In("IN", new InValueProcessor()),
    NotNull("IS NOT NULL", ValueProcessor.EMPTY),
    Null("IS NULL", ValueProcessor.EMPTY),
    Gt(">"),
    Ge(">="),
    Lt("<"),
    Le("<="),
    Eq("="),
    NONE("=");

    @Generated
    private static final Logger log;
    private static final Pattern SUFFIX_PTN;
    private final String op;
    private final ValueProcessor valueProcessor;

    private QuerySuffix(String op) {
        this(op, ValueProcessor.PLACE_HOLDER);
    }

    private QuerySuffix(String op, ValueProcessor valueProcessor) {
        this.op = op;
        this.valueProcessor = valueProcessor;
    }

    static QuerySuffix resolve(String fieldName) {
        Matcher matcher = SUFFIX_PTN.matcher(fieldName);
        return matcher.find() ? QuerySuffix.valueOf(matcher.group()) : NONE;
    }

    static String buildConditionForFieldContainsOr(String fieldNameWithOr, List<Object> argList, Object value) {
        String alias;
        int indexOfDot = fieldNameWithOr.indexOf(46) + 1;
        if (indexOfDot > 0) {
            alias = fieldNameWithOr.substring(0, indexOfDot);
            fieldNameWithOr = fieldNameWithOr.substring(indexOfDot);
        } else {
            alias = "";
        }
        String andSql = Arrays.stream(CommonUtil.splitByOr(fieldNameWithOr)).map(fieldName -> QuerySuffix.buildConditionForField(alias + fieldName, argList, value)).collect(Collectors.joining(" OR "));
        return CommonUtil.wrapWithParenthesis(andSql);
    }

    static String buildConditionForField(String fieldName, List<Object> argList, Object value) {
        QuerySuffix querySuffix = QuerySuffix.resolve(fieldName);
        value = querySuffix.valueProcessor.escapeValue(value);
        String columnName = querySuffix.resolveColumnName(fieldName);
        columnName = CommonUtil.convertColumn(columnName);
        return querySuffix.buildColumnCondition(columnName, argList, value);
    }

    String resolveColumnName(String fieldName) {
        String suffix = this.name();
        return fieldName.endsWith(suffix) ? fieldName.substring(0, fieldName.length() - suffix.length()) : fieldName;
    }

    private String buildColumnCondition(String columnName, List<Object> argList, Object value) {
        if (this.shouldIgnore(value)) {
            return null;
        }
        String placeHolderEx = this.valueProcessor.getPlaceHolderEx(value);
        QuerySuffix.appendArg(argList, value, placeHolderEx);
        return this.buildColumnClause(columnName, placeHolderEx);
    }

    public boolean shouldIgnore(Object value) {
        return this.valueProcessor.shouldIgnore(value);
    }

    private String buildColumnClause(String columnName, String placeHolderEx) {
        if (!placeHolderEx.isEmpty()) {
            placeHolderEx = " " + placeHolderEx;
        }
        return columnName + " " + this.getOp() + placeHolderEx;
    }

    private static void appendArg(List<Object> argList, Object value, String placeHolderEx) {
        if (value instanceof Collection) {
            QuerySuffix.appendCollectionArg(argList, (Collection)value);
        } else if (placeHolderEx.contains("?")) {
            QuerySuffix.appendSingleArg(argList, value);
        }
    }

    private static void appendSingleArg(List<Object> argList, Object value) {
        argList.add(value);
    }

    private static void appendCollectionArg(List<Object> argList, Collection<Object> collection) {
        if (collection.isEmpty()) {
            return;
        }
        Object next = collection.iterator().next();
        if (next instanceof Enum) {
            QuerySuffix.appendEnumCollectionArg(argList, collection, next);
        } else {
            QuerySuffix.appendCommonCollectionArg(argList, collection);
        }
    }

    private static void appendEnumCollectionArg(List<Object> argList, Collection<Object> collection, Object instance) {
        Enumerated enumerated = instance.getClass().getAnnotation(Enumerated.class);
        boolean enumToString = enumerated != null && enumerated.value() == EnumType.STRING;
        Function<Enum, Object> enumMapper = enumToString ? Enum::toString : Enum::ordinal;
        collection.stream().map(element -> enumMapper.apply((Enum)element)).forEach(argList::add);
    }

    private static void appendCommonCollectionArg(List<Object> argList, Collection<Object> collection) {
        argList.addAll(collection);
    }

    @Generated
    public String getOp() {
        return this.op;
    }

    @Generated
    public ValueProcessor getValueProcessor() {
        return this.valueProcessor;
    }

    static {
        log = LoggerFactory.getLogger(QuerySuffix.class);
        List suffixList = Arrays.stream(QuerySuffix.values()).filter(querySuffix -> querySuffix != NONE).map(Enum::name).collect(Collectors.toList());
        String suffixPtn = StringUtils.join(suffixList, (String)"|");
        SUFFIX_PTN = Pattern.compile("(" + suffixPtn + ")$");
    }

    private static class LikeValueProcessor
    implements ValueProcessor {
        private LikeValueProcessor() {
        }

        @Override
        public String getPlaceHolderEx(Object value) {
            return "?";
        }

        @Override
        public boolean shouldIgnore(Object value) {
            if (!(value instanceof String)) {
                log.warn("Type of field which ends with Like should be String.");
                return true;
            }
            return StringUtils.isBlank((CharSequence)((String)value));
        }

        @Override
        public Object escapeValue(Object value) {
            return CommonUtil.escapeLike(String.valueOf(value));
        }
    }

    static class InValueProcessor
    implements ValueProcessor {
        InValueProcessor() {
        }

        @Override
        public boolean shouldIgnore(Object value) {
            if (!(value instanceof Collection)) {
                log.warn("Type of field which ends with In/NotIn should be Collection.");
                return true;
            }
            return false;
        }

        @Override
        public String getPlaceHolderEx(Object value) {
            int size = ((Collection)value).size();
            String placeHolders = IntStream.range(0, size).mapToObj(i -> "?").collect(Collectors.joining(", "));
            return CommonUtil.wrapWithParenthesis(StringUtils.trimToNull((String)placeHolders));
        }
    }

    static interface ValueProcessor {
        public static final ValueProcessor PLACE_HOLDER = value -> "?";
        public static final ValueProcessor EMPTY = value -> "";
        public static final ValueProcessor LIKE_VALUE_PROCESSOR = new LikeValueProcessor();

        public String getPlaceHolderEx(Object var1);

        default public Object escapeValue(Object value) {
            return value;
        }

        default public boolean shouldIgnore(Object value) {
            return false;
        }
    }
}

