/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.service;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.CacheManager;
import org.springframework.cache.support.NoOpCache;
import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.SimpleTransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionOperations;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;
import win.doyto.query.cache.CacheWrapper;
import win.doyto.query.core.DataAccess;
import win.doyto.query.core.IdWrapper;
import win.doyto.query.core.Invocable;
import win.doyto.query.core.JdbcDataAccess;
import win.doyto.query.core.MemoryDataAccess;
import win.doyto.query.core.PageQuery;
import win.doyto.query.entity.EntityAspect;
import win.doyto.query.entity.Persistable;
import win.doyto.query.entity.UserIdProvider;
import win.doyto.query.service.DynamicService;
import win.doyto.query.service.NonNullToStringStyle;
import win.doyto.query.util.BeanUtil;

public abstract class AbstractDynamicService<E extends Persistable<I>, I extends Serializable, Q extends PageQuery>
implements DynamicService<E, I, Q> {
    protected DataAccess<E, I, Q> dataAccess;
    protected final Class<E> entityClass;
    protected final CacheWrapper<E> entityCacheWrapper = CacheWrapper.createInstance();
    protected final CacheWrapper<List<E>> queryCacheWrapper = CacheWrapper.createInstance();
    @Autowired(required=false)
    private UserIdProvider<?> userIdProvider = () -> null;
    @Autowired(required=false)
    private CacheManager cacheManager;
    @Lazy
    @Autowired(required=false)
    protected List<EntityAspect<E>> entityAspects = new LinkedList<EntityAspect<E>>();
    protected TransactionOperations transactionOperations = NoneTransactionOperations.access$000();

    protected AbstractDynamicService() {
        this.entityClass = (Class)BeanUtil.getActualTypeArguments(this.getClass())[0];
        this.dataAccess = new MemoryDataAccess(this.entityClass);
    }

    @Autowired
    public void setJdbcOperations(JdbcOperations jdbcOperations) {
        this.dataAccess = new JdbcDataAccess(jdbcOperations, this.entityClass, (Class)BeanUtil.getActualTypeArguments(this.getClass())[1], this.getRowMapper());
    }

    protected RowMapper<E> getRowMapper() {
        return new BeanPropertyRowMapper(this.entityClass);
    }

    @Autowired(required=false)
    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionOperations = new TransactionTemplate(transactionManager);
    }

    @Value(value="${doyto.query.caches:}")
    public void setCacheList(String caches) {
        String cacheName;
        List cacheList = Arrays.stream(caches.split("[,\\s]")).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        if (this.cacheManager != null && (cacheList.contains(cacheName = this.getCacheName()) || cacheName != this.entityClass.getSimpleName().intern())) {
            this.entityCacheWrapper.setCache(this.cacheManager.getCache(cacheName));
            this.queryCacheWrapper.setCache(this.cacheManager.getCache(this.getQueryCacheName()));
        }
    }

    protected String resolveCacheKey(IdWrapper<I> w) {
        return w.toCacheKey();
    }

    protected String getCacheName() {
        return this.entityClass.getSimpleName().intern();
    }

    private String getQueryCacheName() {
        return this.getCacheName() + ":query";
    }

    protected void clearCache() {
        this.entityCacheWrapper.clear();
        this.queryCacheWrapper.clear();
    }

    protected void evictCache(String key) {
        this.entityCacheWrapper.evict(key);
        this.queryCacheWrapper.clear();
    }

    protected boolean cacheable() {
        return !(this.entityCacheWrapper.getCache() instanceof NoOpCache);
    }

    @Override
    public List<E> query(Q query) {
        String key = this.generateCacheKey(query);
        return this.queryCacheWrapper.execute(key, () -> this.dataAccess.query((PageQuery)query));
    }

    protected String generateCacheKey(Q query) {
        String key = null;
        if (this.cacheable() && !TransactionSynchronizationManager.isActualTransactionActive()) {
            key = ToStringBuilder.reflectionToString(query, (ToStringStyle)NonNullToStringStyle.NO_CLASS_NAME_NON_NULL_STYLE);
        }
        return key;
    }

    @Override
    public long count(Q query) {
        return this.dataAccess.count(query);
    }

    @Override
    public List<I> queryIds(Q query) {
        return this.dataAccess.queryIds(query);
    }

    @Override
    public <V> List<V> queryColumns(Q query, Class<V> clazz, String ... columns) {
        return this.dataAccess.queryColumns(query, clazz, columns);
    }

    @Override
    public void create(E e) {
        this.userIdProvider.setupUserId(e);
        if (!this.entityAspects.isEmpty()) {
            this.transactionOperations.execute(s -> {
                this.dataAccess.create((Persistable)e);
                this.entityAspects.forEach(entityAspect -> entityAspect.afterCreate(e));
                return null;
            });
        } else {
            this.dataAccess.create(e);
        }
        this.evictCache(this.resolveCacheKey(e.toIdWrapper()));
    }

    @Override
    public int update(E e) {
        return this.doUpdate(e, () -> this.dataAccess.update((Persistable)e));
    }

    @Override
    public int patch(E e) {
        return this.doUpdate(e, () -> this.dataAccess.patch((Persistable)e));
    }

    private int doUpdate(E e, Invocable<Integer> invocable) {
        Object origin;
        this.userIdProvider.setupUserId(e);
        if (e == null || (origin = this.dataAccess.get(e.toIdWrapper())) == null) {
            return 0;
        }
        if (!this.entityAspects.isEmpty()) {
            this.transactionOperations.execute(s -> {
                invocable.invoke();
                Object current = this.dataAccess.get(e.toIdWrapper());
                this.entityAspects.forEach(entityAspect -> entityAspect.afterUpdate(origin, current));
                return null;
            });
        } else {
            invocable.invoke();
        }
        this.evictCache(this.resolveCacheKey(e.toIdWrapper()));
        return 1;
    }

    @Override
    public int create(Iterable<E> entities, String ... columns) {
        if (this.userIdProvider.getUserId() != null) {
            for (Persistable e : entities) {
                this.userIdProvider.setupUserId(e);
            }
        }
        int insert = this.dataAccess.batchInsert(entities, columns);
        this.clearCache();
        return insert;
    }

    @Override
    public int patch(E e, Q q) {
        this.userIdProvider.setupUserId(e);
        int patch = this.dataAccess.patch(e, q);
        this.clearCache();
        return patch;
    }

    @Override
    public int delete(Q query) {
        int delete = this.dataAccess.delete(query);
        this.clearCache();
        return delete;
    }

    @Override
    public E get(IdWrapper<I> w) {
        return (E)this.entityCacheWrapper.execute(this.resolveCacheKey(w), () -> this.fetch(w));
    }

    @Override
    public E fetch(IdWrapper<I> w) {
        return this.dataAccess.get(w);
    }

    @Override
    public E delete(IdWrapper<I> w) {
        Object e = this.get(w);
        if (e != null) {
            if (!this.entityAspects.isEmpty()) {
                this.transactionOperations.execute(s -> {
                    this.dataAccess.delete((IdWrapper)w);
                    this.entityAspects.forEach(entityAspect -> entityAspect.afterDelete(e));
                    return null;
                });
            } else {
                this.dataAccess.delete(w);
            }
            String key = this.resolveCacheKey(w);
            this.evictCache(key);
            this.entityCacheWrapper.execute(key, () -> null);
        }
        return e;
    }

    @Generated
    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    private static class NoneTransactionOperations
    implements TransactionOperations {
        private static final TransactionOperations instance = new NoneTransactionOperations();
        private static final TransactionStatus TRANSACTION_STATUS = new SimpleTransactionStatus();

        private NoneTransactionOperations() {
        }

        public <T> T execute(TransactionCallback<T> transactionCallback) {
            return (T)transactionCallback.doInTransaction(TRANSACTION_STATUS);
        }

        static /* synthetic */ TransactionOperations access$000() {
            return instance;
        }
    }
}

