/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

public interface AssociativeService<L, R> {
    public List<R> getByLeftId(L var1);

    public int deleteByLeftId(L var1);

    public List<L> getByRightId(R var1);

    public int deleteByRightId(R var1);

    public boolean exists(Collection<L> var1, Collection<R> var2);

    default public boolean exists(L leftId, R rightId) {
        return this.exists(leftId, (Collection<R>)Collections.singleton(rightId));
    }

    default public boolean exists(L leftId, Collection<R> rightIds) {
        return this.exists((Collection<L>)Collections.singleton(leftId), (R)rightIds);
    }

    default public boolean exists(Collection<L> leftIds, R rightId) {
        return this.exists(leftIds, (R)Collections.singleton(rightId));
    }

    public long count(Collection<L> var1, Collection<R> var2);

    default public int allocate(L leftId, R rightId) {
        return !this.exists(leftId, rightId) ? this.allocate((Collection<L>)Collections.singleton(leftId), (Collection<R>)Collections.singleton(rightId)) : 0;
    }

    public int allocate(Collection<L> var1, Collection<R> var2);

    default public void deallocate(L leftId, R rightId) {
        this.deallocate((Collection<L>)Collections.singleton(leftId), (Collection<R>)Collections.singleton(rightId));
    }

    public int deallocate(Collection<L> var1, Collection<R> var2);

    public int reallocateForLeft(L var1, Collection<R> var2);

    public int reallocateForRight(R var1, Collection<L> var2);
}

