/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import win.doyto.query.core.SqlAndArgs;

class AssociativeSqlBuilder {
    public static final String WHERE = " WHERE ";
    public static final String IN_S = " IN (%s)";
    public static final String DELETE_FROM = "DELETE FROM ";
    private final String deallocateFormat;
    private final String count;
    private final String insert;
    private final String insertPlaceholders;
    private final boolean insertCreateUser;
    final String getByLeftId;
    final String deleteByLeftId;
    final String getByRightId;
    final String deleteByRightId;

    public AssociativeSqlBuilder(String table, String left, String right, String createUserColumn) {
        this.deallocateFormat = DELETE_FROM + table + WHERE + left + IN_S + " AND " + right + IN_S;
        this.count = "SELECT COUNT(*) FROM " + table + WHERE + left + IN_S + " AND " + right + IN_S;
        if (createUserColumn == null) {
            this.insert = "INSERT INTO " + table + " (" + left + ", " + right + ") values (?, ?)";
            this.insertPlaceholders = ", (?, ?)";
            this.insertCreateUser = false;
        } else {
            this.insert = "INSERT INTO " + table + " (" + left + ", " + right + ", " + createUserColumn + ") values (?, ?, ?)";
            this.insertPlaceholders = ", (?, ?, ?)";
            this.insertCreateUser = true;
        }
        this.getByLeftId = "SELECT " + right + " FROM " + table + WHERE + left + " = ?";
        this.deleteByLeftId = DELETE_FROM + table + WHERE + left + " = ?";
        this.getByRightId = "SELECT " + left + " FROM " + table + WHERE + right + " = ?";
        this.deleteByRightId = DELETE_FROM + table + WHERE + right + " = ?";
    }

    private String generatePlaceHolders(int size) {
        return "?" + IntStream.range(1, size).mapToObj(i -> ", ?").collect(Collectors.joining());
    }

    private List<Object> unionArgs(Object[] leftIds, Object[] rightIds) {
        ArrayList<Object> argList = new ArrayList<Object>(leftIds.length + rightIds.length);
        Collections.addAll(argList, leftIds);
        Collections.addAll(argList, rightIds);
        return argList;
    }

    public SqlAndArgs buildDeallocate(Object[] leftIds, Object[] rightIds) {
        String sql = String.format(this.deallocateFormat, this.generatePlaceHolders(leftIds.length), this.generatePlaceHolders(rightIds.length));
        return new SqlAndArgs(sql, this.unionArgs(leftIds, rightIds));
    }

    public SqlAndArgs buildCount(Object[] leftIds, Object[] rightIds) {
        String sql = String.format(this.count, this.generatePlaceHolders(leftIds.length), this.generatePlaceHolders(rightIds.length));
        return new SqlAndArgs(sql, this.unionArgs(leftIds, rightIds));
    }

    public SqlAndArgs buildAllocate(Collection<?> leftIds, Collection<?> rightIds, Object userId) {
        StringBuilder sql = new StringBuilder(this.insert);
        int totalSize = leftIds.size() * rightIds.size();
        for (int i = 0; i < totalSize - 1; ++i) {
            sql.append(this.insertPlaceholders);
        }
        ArrayList<Object> args = new ArrayList<Object>(totalSize * (this.insertCreateUser ? 3 : 2));
        for (Object leftId : leftIds) {
            for (Object rightId : rightIds) {
                args.add(leftId);
                args.add(rightId);
                if (!this.insertCreateUser) continue;
                args.add(userId);
            }
        }
        return new SqlAndArgs(sql.toString(), args);
    }
}

