/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.service;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import win.doyto.query.service.NonNullToStringStyle;

class CollectionUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CollectionUtil.class);

    public static <E> E first(List<E> iterable) {
        return CollectionUtil.first(iterable, null);
    }

    public static <E> E first(List<E> list, Object info) {
        try {
            E e = list.isEmpty() ? null : (E)list.get(0);
            return e;
        }
        finally {
            if (list.size() > 1) {
                CollectionUtil.debugRepetitiveElements(list, info);
            }
        }
    }

    static <E> void debugRepetitiveElements(List<E> list, Object info) {
        StringBuilder sb = new StringBuilder();
        int size = list.size();
        int end = Math.min(3, size);
        for (int i = 0; i < end; ++i) {
            E e = list.get(i);
            sb.append("\n").append(CollectionUtil.objectDetail(e));
        }
        if (size > 3) {
            sb.append("\n...");
        }
        log.warn("Found {} elements of {}{}", new Object[]{size, list.get(0).getClass(), info == null ? "" : " for query: " + CollectionUtil.objectDetail(info)});
        log.warn("Repetitive elements: {}", (Object)sb.toString());
        log.warn("\n  - {}", (Object)StringUtils.join((Object[])Arrays.copyOfRange(new Exception().getStackTrace(), 1, 6), (String)"\n  - "));
    }

    private static String objectDetail(Object target) {
        return target instanceof String ? (String)target : ToStringBuilder.reflectionToString((Object)target, (ToStringStyle)NonNullToStringStyle.NON_NULL_STYLE);
    }

    @Generated
    private CollectionUtil() {
    }
}

