/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.service;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import win.doyto.query.core.PageQuery;
import win.doyto.query.service.CollectionUtil;
import win.doyto.query.service.PageList;

public interface QueryService<E, Q extends PageQuery> {
    public List<E> query(Q var1);

    public long count(Q var1);

    default public boolean exists(Q query) {
        return this.count(query) > 0L;
    }

    default public boolean notExists(Q query) {
        return !this.exists(query);
    }

    default public E get(Q query) {
        return CollectionUtil.first(this.query(query), query);
    }

    default public <V> V get(Q query, Function<E, V> transfer) {
        return CollectionUtil.first(this.query(query, transfer), query);
    }

    default public <V> List<V> query(Q query, Function<E, V> transfer) {
        return this.query(query).stream().map(transfer).collect(Collectors.toList());
    }

    default public PageList<E> page(Q query) {
        ((PageQuery)query).forcePaging();
        return new PageList<E>(this.query(query), this.count(query));
    }

    default public <V> PageList<V> page(Q query, Function<E, V> transfer) {
        ((PageQuery)query).forcePaging();
        return new PageList<V>(this.query(query, transfer), this.count(query));
    }
}

