/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.transaction.annotation.Transactional;
import win.doyto.query.core.SqlAndArgs;
import win.doyto.query.entity.UserIdProvider;
import win.doyto.query.service.AssociativeService;
import win.doyto.query.service.AssociativeSqlBuilder;

public class TemplateAssociativeService<L, R>
implements AssociativeService<L, R> {
    private final AssociativeSqlBuilder sqlBuilder;
    private final SingleColumnRowMapper<L> leftRowMapper = new SingleColumnRowMapper();
    private final SingleColumnRowMapper<R> rightRowMapper = new SingleColumnRowMapper();
    @Autowired
    private JdbcOperations jdbcOperations;
    @Autowired(required=false)
    private UserIdProvider<?> userIdProvider = () -> null;

    public TemplateAssociativeService(String table, String left, String right) {
        this(table, left, right, null);
    }

    public TemplateAssociativeService(String table, String left, String right, String createUserColumn) {
        this.sqlBuilder = new AssociativeSqlBuilder(table, left, right, createUserColumn);
    }

    @Override
    public boolean exists(Collection<L> leftIds, Collection<R> rightIds) {
        return this.count(leftIds, rightIds) > 0L;
    }

    @Override
    public long count(Collection<L> leftIds, Collection<R> rightIds) {
        return this.count(leftIds.toArray(), rightIds.toArray());
    }

    private Long count(Object[] leftIds, Object[] rightIds) {
        if (leftIds.length == 0 || rightIds.length == 0) {
            return 0L;
        }
        SqlAndArgs sqlAndArgs = this.sqlBuilder.buildCount(leftIds, rightIds);
        return (Long)this.jdbcOperations.queryForObject(sqlAndArgs.getSql(), sqlAndArgs.getArgs(), Long.class);
    }

    @Override
    public List<R> getByLeftId(L leftId) {
        SqlAndArgs.logSqlInfo(this.sqlBuilder.getByLeftId, Collections.singletonList(leftId));
        return this.jdbcOperations.query(this.sqlBuilder.getByLeftId, this.rightRowMapper, new Object[]{leftId});
    }

    @Override
    public int deleteByLeftId(L leftId) {
        SqlAndArgs.logSqlInfo(this.sqlBuilder.deleteByLeftId, Collections.singletonList(leftId));
        return this.jdbcOperations.update(this.sqlBuilder.deleteByLeftId, new Object[]{leftId});
    }

    @Override
    public List<L> getByRightId(R rightId) {
        SqlAndArgs.logSqlInfo(this.sqlBuilder.getByRightId, Collections.singletonList(rightId));
        return this.jdbcOperations.query(this.sqlBuilder.getByRightId, this.leftRowMapper, new Object[]{rightId});
    }

    @Override
    public int deleteByRightId(R rightId) {
        SqlAndArgs.logSqlInfo(this.sqlBuilder.deleteByRightId, Collections.singletonList(rightId));
        return this.jdbcOperations.update(this.sqlBuilder.deleteByRightId, new Object[]{rightId});
    }

    @Override
    public int deallocate(Collection<L> leftIds, Collection<R> rightIds) {
        SqlAndArgs sqlAndArgs = this.sqlBuilder.buildDeallocate(leftIds.toArray(), rightIds.toArray());
        return this.jdbcOperations.update(sqlAndArgs.getSql(), sqlAndArgs.getArgs());
    }

    @Override
    @Transactional
    public int reallocateForLeft(L leftId, Collection<R> rightIds) {
        this.deleteByLeftId(leftId);
        if (rightIds.isEmpty()) {
            return 0;
        }
        return this.allocate((Collection<L>)Collections.singleton(leftId), rightIds);
    }

    @Override
    @Transactional
    public int reallocateForRight(R rightId, Collection<L> leftIds) {
        this.deleteByRightId(rightId);
        if (leftIds.isEmpty()) {
            return 0;
        }
        return this.allocate(leftIds, (Collection<R>)Collections.singleton(rightId));
    }

    @Override
    public int allocate(Collection<L> leftIds, Collection<R> rightIds) {
        SqlAndArgs sqlAndArgs = this.sqlBuilder.buildAllocate(leftIds, rightIds, this.userIdProvider.getUserId());
        return this.jdbcOperations.update(sqlAndArgs.getSql(), sqlAndArgs.getArgs());
    }
}

